
#include "config_xor.h"

#include <string.h>
#include "CuTest.h"
#include "samhain.h"
#include "sh_utils.h"

void Test_sh_util_obscure_ok (CuTest *tc) {

  int ret = 0;
#if defined(SH_WITH_CLIENT) || defined(SH_STANDALONE)
  char input[16] = "foobar";

  ret = sh_util_obscure_ok ("0xA1,0xA2,0xA3");
  CuAssertIntEquals(tc, ret, 0);

  ret = sh_util_obscurename (0, input, S_FALSE /* no log message */);
  CuAssertIntEquals(tc, ret, 0);

  input[0] = '\t';
  ret = sh_util_obscurename (0, input, S_FALSE /* no log message */);
  CuAssertIntEquals(tc, ret, -1);

  input[0] = 0xA1;
  ret = sh_util_obscurename (0, input, S_FALSE /* no log message */);
  CuAssertIntEquals(tc, ret, 0);

  input[0] = 0xA2;
  ret = sh_util_obscurename (0, input, S_FALSE /* no log message */);
  CuAssertIntEquals(tc, ret, 0);

  input[0] = 0xA3;
  ret = sh_util_obscurename (0, input, S_FALSE /* no log message */);
  CuAssertIntEquals(tc, ret, 0);

  input[0] = 0xA4;
  ret = sh_util_obscurename (0, input, S_FALSE /* no log message */);
  CuAssertIntEquals(tc, ret, -1);

#else
  CuAssertIntEquals(tc, ret, 0);
#endif
}


