#! /bin/sh

SERVER_BUILDOPTS="--quiet  $TRUST --enable-xml-log --enable-debug --enable-network=server --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=REQ_FROM_SERVER$PW_DIR/testrc_2 --with-data-file=REQ_FROM_SERVER$PW_DIR/.samhain_file --with-logserver=${SH_LOCALHOST}  --with-log-file=$PW_DIR/.samhain_log --with-pid-file=$PW_DIR/.samhain_lock --with-database=mysql"; export SERVER_BUILDOPTS

CLIENT_BUILDOPTS="--quiet  $TRUST --prefix=$PW_DIR --localstatedir=$PW_DIR --enable-network=client --disable-mail --disable-external-scripts --enable-login-watch --enable-xml-log --enable-db-reload --with-logserver=localhost --with-config-file=REQ_FROM_SERVER$PW_DIR/testrc_2 --with-data-file=REQ_FROM_SERVER$PW_DIR/.samhain_file --with-log-file=$PW_DIR/.samhain_log --with-pid-file=$PW_DIR/.samhain_lock"; export CLIENT_BUILDOPTS

check_mysql_log () {
    DATE="$1"

    rm -f test_log_db
    echo "SELECT * FROM log WHERE entry_status = 'NEW' and log_time > '"${DATE}"';" | mysql --password=samhain -u samhain samhain >test_log_db
    #
    egrep "START.*Yule" test_log_db >/dev/null 2>&1
    if [ $? -ne 0 ]; then
	[ -z "$verbose" ] || log_msg_fail "Server start";
	return 1
    fi
    egrep "NEW CLIENT" test_log_db >/dev/null 2>&1
    if [ $? -ne 0 ]; then
	[ -z "$verbose" ] || log_msg_fail "Client connect";
	return 1
    fi
    egrep "Checking.*/bin" test_log_db >/dev/null 2>&1
    if [ $? -ne 0 ]; then
	[ -z "$verbose" ] || log_msg_fail "Client file check";
	return 1
    fi
    egrep "EXIT.*Samhain" test_log_db >/dev/null 2>&1
    if [ $? -ne 0 ]; then
	[ -z "$verbose" ] || log_msg_fail "Client exit";
	return 1
    fi
    egrep "EXIT.*Yule.*SIGTERM" test_log_db >/dev/null 2>&1
    if [ $? -ne 0 ]; then
	[ -z "$verbose" ] || log_msg_fail "Server exit";
	return 1
    fi
    return 0
}

MAXTEST=1; export MAXTEST

testrun2c ()
{
    log_start "RUN FULL CLIENT/SERVER W/MYSQL"
    #
    if [ -z "$doall" ]; then
	log_skip 1 $MAXTEST 'Client/server w/mysql (or use --really-all)'
	return 0
    fi
    if [ x"$1" = x ]; then
	[ -z "$quiet" ] && log_msg_fail "Missing hostname"
    fi
    MYSQL=`find_path mysql`
    if [ -z "$MYSQL" ]; then
	log_skip 1 $MAXTEST "mysql not found";
	return 1
    else
	TEST=`echo "DESCRIBE log;" | mysql --password=samhain -u samhain samhain 2>/dev/null`
	if [ $? -ne 0 -o -z "$TEST" ]; then
	    log_skip 1 $MAXTEST "mysql not default setup"
	    return 1
	fi
    fi
    #
    SH_LOCALHOST=$1; export SH_LOCALHOST
    #
    DATE=`date '+%Y-%m-%d %T'`
    #
    testrun2a_internal
    #
    ORIGINAL="DatabaseSeverity=none"
    REPLACEMENT="DatabaseSeverity=info"
    ex $RCFILE <<EOF
:%s/$ORIGINAL/$REPLACEMENT/g
:wq
EOF
    #
    do_test_1_a
    if [ $? -ne 0 ]; then
	[ -z "$quiet" ] && log_fail 1 ${MAXTEST} "Client/server w/mysql";
    else
    #
	check_mysql_log "${DATE}"
	if [ $? -ne 0 ]; then
	    [ -z "$quiet" ] && log_fail 1 ${MAXTEST} "Client/server w/mysql";
	else
	    [ -z "$quiet" ] && log_ok   1 ${MAXTEST} "Client/server w/mysql";
	fi
    fi
    #
    if [ -n "$cleanup" ]; then
	rm -f ./rc.${SH_LOCALHOST}
	rm -f ./file.${SH_LOCALHOST}
	ALTHOST=`find_hostname`
	rm -f "./file.${ALTHOST}"
	rm -f "./rc.${ALTHOST}"
    fi
    #
    log_end "RUN FULL CLIENT/SERVER W/MYSQL"
}

