#! /bin/sh

isok=`test -t 1 2>&1 | wc -c`
if [ "$isok" -eq 0 ]; then
   test -t 1
   isok=$?
fi

# The following two are the ANSI sequences for start and end embolden
if [ x"$isok" = x0 ]; then
    case $TERM in
	vt*|ansi*|con*|xterm*|linux*|screen*|rxvt*)
	    S='[1;30m'
	    R=[31m
	    G=[32m
	    B=[36m
	    E=[m
	    ;;
	*)
	    S=
	    R=
	    G=
	    B=
	    E=
	    ;;
    esac
fi


usage() {
    echo "test.sh [options] <test_number> [hostname]"
    echo "        [-q|--quiet|-v|--verbose] [-s|--stoponerr] [--no-cleanup]"
    echo "        [--srcdir=top_srcdir] [--color=always|never|auto]"
    echo
    echo "  ${S}test.sh  1${E}  -- Compile with many different options"
    echo "  ${S}test.sh  2${E}  -- Hash function            (testrc_1)"
    echo "  ${S}test.sh  3${E}  -- Standalone init/check"
    echo "  ${S}test.sh  4${E}  -- Microstealth init/check"
    echo "  ${S}test.sh  5${E}  -- External program call    (testrc_1ext.in)"
    echo "  ${S}test.sh  6${E}  -- Controlling the daemon"
    echo "  ${S}test.sh  7${E}  -- GnuPG signed files / prelude log"

    echo "  ${S}test.sh 10${E}  -- Test c/s init/check      (testrc_2.in)"
    echo "  ${S}test.sh 11${E}  -- Test full c/s init/check (testrc_2.in)"
    echo "  ${S}test.sh 12${E}  -- Test full c/s w/gpg      (testrc_2.in)"
    echo "  ${S}test.sh 13${E}  -- Test full c/s w/mysql    (testrc_2.in)"
    echo "  ${S}test.sh 14${E}  -- Test full c/s w/postgres (testrc_2.in)"
    echo "  ${S}test.sh all${E} -- All except 12+"
    
    echo 
    echo "Scripts used by tests (located in ${SCRIPTDIR}):"
    echo "  (1) testcompile.sh (2) testhash.sh     (3) testrun_1.sh   (4) testrun_1a.sh"
    echo "  (5) testext.sh     (6) testtimesrv.sh  (7) testrun_1b.sh (10) testrun_2.sh"
    echo " (11) testrun_2a.sh (12) testrun_2b.sh  (13) testrun_2c.sh (14) testrun_2d.sh"
}

#
# Option parsing
#
verbose=
quiet=
stoponerr=
color=auto
cleanup=on
doall=

while [ $# -gt 0 ]
do
    case "$1" in
        -h|--help)     usage; exit 0;;
        -v|--verbose)  verbose=on; quiet= ;;
        -q|--quiet)    quiet=on; verbose= ;;
        -s|--stoponerr)     stoponerr=on;;
	--no-cleanup) cleanup= ;;
	--really-all) doall=on;;
	--srcdir=*)    TOP_SRCDIR=`echo $1 | sed s,--srcdir=,,`; export TOP_SRCDIR;;
	--color=*)     
	    arg=`echo $1 | sed s,--color=,,`
	    case $arg in
		auto) ;;
		never|none|no) 
		    S=
		    R=
		    G=
		    B=
		    E=
		    ;;
		always|yes)
		    S='[1;30m'
		    R=[31m
		    G=[32m
		    G=[36m
		    E=[m
		    ;;
		*) echo "Invalid argument $1"; exit 1;;
	    esac
	    ;;
        -*)  echo "Invalid argument $1"; exit 1;;
	*) break;;
    esac
    shift
done

export verbose
export quiet
export stoponerr
export cleanup
export doall
export S; export R; export G; export B; export E;

SCRIPTDIR=.

#
# 'make test' will copy the 'test' subdirectory and replace TEST_SRCDIR
#
TEST_SRCDIR="XXXSRCXXX";
if test "x${TOP_SRCDIR}" = x; then
    # not within source tree, and not called with 'make testN'
    if test -f "${TEST_SRCDIR}/src/samhain.c"; then
	TOP_SRCDIR="${TEST_SRCDIR}"; export TOP_SRCDIR
        if test -f test/testcompile.sh; then
            SCRIPTDIR=test
        fi
    # not within source tree, not called by 'make', and in 'test' subdir
    elif test -f "../${TEST_SRCDIR}/src/samhain.c"; then
	cd ..
	SCRIPTDIR=test
	TOP_SRCDIR="${TEST_SRCDIR}"; export TOP_SRCDIR
    # within source tree, and not called with 'make testN'
    else
	if test -f ../src/samhain.c; then
	    cd .. 
	    SCRIPTDIR=test
	    TOP_SRCDIR=. 
            export TOP_SRCDIR
	elif test -f ./src/samhain.c; then
	    SCRIPTDIR=test
	    TOP_SRCDIR=.
	    export TOP_SRCDIR
	else
	    echo "Please use --srcdir=DIR, where DIR should be the"
	    echo "top directory in the samhain source tree."
	    exit 1
	fi
    fi
else
    # called by make, or with --srcdir=TOP_SRCDIR
    if   test -f "${TOP_SRCDIR}/src/samhain.c"; then
	SCRIPTDIR="${TOP_SRCDIR}/test"
    elif test -f "../${TOP_SRCDIR}/src/samhain.c"; then
	cd ..; SCRIPTDIR="${TOP_SRCDIR}/test"
    else
	echo "Please use --srcdir=DIR, where DIR should be the"
	echo "top directory in the samhain source tree."
	exit 1
    fi
fi

export SCRIPTDIR

PW_DIR=`pwd`; export PW_DIR
#
#
#
if test x$UID != x; then
  TRUST="--with-trusted=0,2,$UID"
else
  TRUST="--with-trusted=0,2,500"
fi
export TRUST
#
# find a good 'make'
#
MAKE=`which gmake`
if test "x$?" = x1 ; then
    MAKE="make -s"
else
    MAKE=`which gmake | sed -e "s%\([a-z:]\) .*%\1%g"` 
    if test "x$MAKE" = x; then
	MAKE="make -s"
    elif test "x$MAKE" = xno; then
	MAKE="make -s"
    else
	if test "x$MAKE" = "xwhich:"; then
		MAKE="make -s"
	else
		MAKE="gmake -s"
		gmake -v >/dev/null 2>&1 || MAKE="make -s"
	fi
    fi
fi
export MAKE

failcount=0
okcount=0
skipcount=0
global_count=0
last_count=0

# args: #test, #total, status, optional msg
log_msg ()
{
    if   [ x"$COLUMNS" != x ]; then
	TERMWIDTH=$COLUMNS
    elif [ x"$COLS" != x ]; then
	TERMWIDTH=$COLS
    else
	TERMWIDTH=80
    fi
    cols=66; 
    #
    if [ $1 -eq 0 ]; then
	msg=" ${4}"
    else
	if [ ${1} -eq 1 ]; then
	    global_count=${last_count}
	fi
	let "v = $1 + global_count" >/dev/null
	last_count=${v}
	dd=''; if [ $v -lt 10 ]; then dd=" "; fi
	dt=''; if [ $2 -lt 10 ]; then dt=" "; fi
	if [ -z "$4" ]; then
	    msg=" test ${dd}${v}/${dt}${2}"
	else
	    msg=" test ${dd}${v}/${dt}${2}    ${4}"
	fi
    fi
    #
    if   [ x"$3" = xfailure ]; then
	ccode=$R
    elif [ x"$3" = xsuccess ]; then
	ccode=$G
    else
	ccode=$B
    fi
    if [ -z "${R}" ]; then
	echo " [${3}] ${msg}"
    else
	# len=${#...} is not bourne shell
	# also, need to account for terminal control sequences
	len=`echo "$msg" | awk '/1;30m/ { print length()-10; }; !/1;30m/ { print length();}'`
	let "cols = cols - len" >/dev/null
	moveto='['$cols'C'
	echo "${msg}${moveto}${ccode}[${3}]${E}"
    fi
}

log_fail () { 
    log_msg "$1" "$2" failure "$3"; 
    let "failcount = failcount + 1" >/dev/null; 
    test -z "$stoponerr" || exit 1; 
}
log_ok ()   { 
    log_msg "$1" "$2" success "$3"; 
    let "okcount = okcount + 1" >/dev/null; 
}
log_skip () { 
    log_msg "$1" "$2" skipped "$3"; 
    let "skipcount = skipcount + 1" >/dev/null; 
}

log_msg_fail () { log_msg 0 0 failure "$1"; }
log_msg_ok ()   { log_msg 0 0 success "$1"; }
log_msg_skip () { log_msg 0 0 skipped "$1"; }

log_start () {
    if [ -z "$quiet" ]; then
	echo; 
	echo "${S}__ START TEST ${1} __${E}"; 
	echo; 
    fi
}
log_end () {
    if [ -n "$verbose" ]; then
	echo; 
	echo "${S}__ END   TEST ${1} __${E}"; 
	echo; 
    fi
}

do_cleanup () {
    rm -f testrc_1.dyn
    rm -f testrc_2
    rm -f ./.samhain_file
    rm -f ./.samhain_log*
    rm -f ./.samhain_lock
    test -d testrun_data && chmod -R 0700 testrun_data
    rm -rf testrun_data
    rm -f test_log_db
    rm -f test_log_prelude
}

print_summary ()
{
    let "gcount = okcount + skipcount + failcount" >/dev/null;
    [ -z "$quiet" ] && { 
	echo
	echo "__ ${S}Tests: ${gcount}  Ok: ${okcount} Skipped: ${skipcount} Failed: ${failcount}${E}"
    }
    if [ $failcount -eq 0 ]; then
	[ -z "$quiet" ] && { echo "__ ${G}All tests passed successfully.${E}"; echo; }
    elif [ $failcount -eq 1 ]; then
	[ -z "$quiet" ] && { echo "__ ${R}There was 1 failure.${E}"; echo; }
    else
	[ -z "$quiet" ] && { echo "__ ${R}There were $failcount failures.${E}"; echo; }
    fi
    [ -z "$cleanup" ] || do_cleanup;
}

find_path () { (   
    save_IFS=$IFS; IFS=:

    for dir in $PATH; do
	IFS=$as_save_IFS
	test -z "$dir" && dir=.
	if test -f "$dir/$1"; then
	    echo "$dir/$1";
	    break;
	fi
    done
    IFS=${save_IFS};
); }

find_hostname () {
    tmp=`hostname -f 2>/dev/null`
    if [ $? -ne 0 ]; then
	tmp=`hostname 2>/dev/null`
    fi
    if [ -z "$tmp" ]; then
	tmp="localhost"
    fi
    echo "$tmp"
}

rm -f ./test_log

# first one is hostname, others are aliases
#
hostname=`cat /etc/hosts | egrep "^ *127.0.0.1" | awk '{ print $2 }'`
if [ x"$hostname" = xlocalhost ]; then
    hostname="127.0.0.1"
fi

if test x$1 = x1; then
    . ${SCRIPTDIR}/testcompile.sh
    testcompile
    print_summary
    exit $?
fi
if test x$1 = x2; then
    . ${SCRIPTDIR}/testhash.sh
    testhash
    print_summary
    exit $?
fi
if test x$1 = x3; then
    . ${SCRIPTDIR}/testrun_1.sh
    testrun1
    print_summary
    exit $?
fi
if test x$1 = x4; then
    . ${SCRIPTDIR}/testrun_1.sh
    . ${SCRIPTDIR}/testrun_1a.sh
    testrun1a
    print_summary
    exit $?
fi
if test x$1 = x5; then
    . ${SCRIPTDIR}/testext.sh
    testext0
    print_summary
    exit $?
fi
if test x$1 = x6; then
    . ${SCRIPTDIR}/testtimesrv.sh
    testtime0
    print_summary
    exit $?
fi
if test x$1 = x7; then
    . ${SCRIPTDIR}/testrun_1b.sh
    testrun1b
    print_summary
    exit $?
fi
if test x$1 = x10; then
    . ${SCRIPTDIR}/testrun_2.sh 
    testrun2 $hostname
    print_summary
    exit $?
fi
if test x$1 = x11; then
    . ${SCRIPTDIR}/testrun_2a.sh
    testrun2a $hostname
    print_summary
    exit $?
fi
if test x$1 = x12; then
    . ${SCRIPTDIR}/testrun_2a.sh
    . ${SCRIPTDIR}/testrun_2b.sh
    testrun2b $hostname
    print_summary
    exit $?
fi
if test x$1 = x13; then
    . ${SCRIPTDIR}/testrun_2a.sh
    . ${SCRIPTDIR}/testrun_2c.sh 
    testrun2c $hostname
    print_summary
    exit $?
fi
if test x$1 = x14; then
    . ${SCRIPTDIR}/testrun_2a.sh
    . ${SCRIPTDIR}/testrun_2d.sh
    testrun2d $hostname
    print_summary
    exit $?
fi
if test x$1 = xall; then
    TEST_MAX=0
    . ${SCRIPTDIR}/testcompile.sh
    let "TEST_MAX = TEST_MAX + MAXTEST" >/dev/null
    . ${SCRIPTDIR}/testhash.sh
    let "TEST_MAX = TEST_MAX + MAXTEST" >/dev/null
    . ${SCRIPTDIR}/testrun_1.sh
    let "TEST_MAX = TEST_MAX + MAXTEST" >/dev/null
    . ${SCRIPTDIR}/testrun_1a.sh
    let "TEST_MAX = TEST_MAX + MAXTEST" >/dev/null
    . ${SCRIPTDIR}/testext.sh
    let "TEST_MAX = TEST_MAX + MAXTEST" >/dev/null
    . ${SCRIPTDIR}/testtimesrv.sh
    let "TEST_MAX = TEST_MAX + MAXTEST" >/dev/null
    . ${SCRIPTDIR}/testrun_1b.sh
    let "TEST_MAX = TEST_MAX + MAXTEST" >/dev/null
    . ${SCRIPTDIR}/testrun_2.sh
    let "TEST_MAX = TEST_MAX + MAXTEST" >/dev/null
    . ${SCRIPTDIR}/testrun_2a.sh
    let "TEST_MAX = TEST_MAX + MAXTEST" >/dev/null
    . ${SCRIPTDIR}/testrun_2b.sh
    let "TEST_MAX = TEST_MAX + MAXTEST" >/dev/null
    . ${SCRIPTDIR}/testrun_2c.sh
    let "TEST_MAX = TEST_MAX + MAXTEST" >/dev/null
    . ${SCRIPTDIR}/testrun_2d.sh
    let "TEST_MAX = TEST_MAX + MAXTEST" >/dev/null
    #
    # ${SCRIPTDIR}/testtimesrv.sh
    # ${SCRIPTDIR}/testrun_1b.sh
    # ${SCRIPTDIR}/testrun_2.sh $2
    # ${SCRIPTDIR}/testrun_2a.sh $2
    #
    MAXTEST=${TEST_MAX}; export MAXTEST
    testcompile
    testhash
    #
    . ${SCRIPTDIR}/testrun_1.sh
    MAXTEST=${TEST_MAX}; export MAXTEST
    testrun1
    #
    . ${SCRIPTDIR}/testrun_1a.sh
    MAXTEST=${TEST_MAX}; export MAXTEST
    testrun1a
    #
    testext0
    #
    . ${SCRIPTDIR}/testtimesrv.sh
    MAXTEST=${TEST_MAX}; export MAXTEST
    testtime0
    #
    . ${SCRIPTDIR}/testrun_1b.sh
    MAXTEST=${TEST_MAX}; export MAXTEST
    testrun1b
    #
    . ${SCRIPTDIR}/testrun_2.sh
    MAXTEST=${TEST_MAX}; export MAXTEST
    testrun2 $hostname
    #
    . ${SCRIPTDIR}/testrun_2a.sh
    MAXTEST=${TEST_MAX}; export MAXTEST
    testrun2a $hostname
    #
    . ${SCRIPTDIR}/testrun_2b.sh
    MAXTEST=${TEST_MAX}; export MAXTEST
    testrun2b $hostname
    #
    . ${SCRIPTDIR}/testrun_2c.sh
    MAXTEST=${TEST_MAX}; export MAXTEST
    testrun2c $hostname
    #
    . ${SCRIPTDIR}/testrun_2d.sh
    MAXTEST=${TEST_MAX}; export MAXTEST
    testrun2d $hostname
    #
    print_summary
    exit 0
fi

usage;

exit 1;

__ARCHIVE_FOLLOWS__
 -tC Mo0#@Hą	4&m׎I9Me6U(M[bwv |W$ĉݺMHl?q1;ʥ
ҩTXjyu֦iUM*hLBMiPI'J}A0?gG!ټUek6JV5oJ0m>X*Ms"\$uEe"{c0# w6aq;B"7P8q%[QHZT#[#8i "j1:¤/:(	eJ	'5p]}d32!	f1љRšLgMLTl!τi1wOiA4ج`i#1LDürCPCqLIY,D,S:JuMrpxMd	
mp-2ZE`GdW%bUm˘{悙])de`x
Kl\j:u=7az+k[]g|#<X{ZE:e	Y]+xĸ
=Kjt*FӤ_W?}|11܌I\XWiO{wGy(?޼|c_/x͋i	؋sra׊hc'Ckt#9M%d3l-v.<7KH$D"H$D"H$D"H$	?:v (  