#! /bin/sh


# The following two are the ANSI sequences for start and end embolden
case $TERM in
vt*|ansi*|con*|xterm*|linux*|screen*)
  S=[1m
  E=[m
  ;;
*)
  S=
  E=
  ;;
esac

SCRIPTDIR=.

TEST_SRCDIR="XXXSRCXXX";
if test "x${TOP_SRCDIR}" = x; then
    # not within source tree, and not called with 'make testN'
    if test -f "${TEST_SRCDIR}/src/samhain.c"; then
	TOP_SRCDIR="${TEST_SRCDIR}"; export TOP_SRCDIR
        if test -f test/testcompile.sh; then
            SCRIPTDIR=test
        fi
    # not within source tree, not called by 'make', and in 'test' subdir
    elif test -f "../${TEST_SRCDIR}/src/samhain.c"; then
	cd ..
	SCRIPTDIR=test
	TOP_SRCDIR="${TEST_SRCDIR}"; export TOP_SRCDIR
    # within source tree, and not called with 'make testN'
    else
	if test -f ../src/samhain.c; then
	    cd .. 
	    SCRIPTDIR=test
	    TOP_SRCDIR=. 
            export TOP_SRCDIR
	elif test -f ./src/samhain.c; then
	    SCRIPTDIR=test
	    TOP_SRCDIR=.
	    export TOP_SRCDIR
	else
	    echo "Please set the environment variable TOP_SRCDIR to the"
	    echo "top directory in the samhain source tree."
	    exit 1
	fi
    fi
else
    # called by make
    if test -f "${TOP_SRCDIR}/src/samhain.c"; then
	SCRIPTDIR=test
    else
	if test -f "../${TOP_SRCDIR}/src/samhain.c"; then
	    cd ..; SCRIPTDIR=test
	else
	    echo "Please set the environment variable TOP_SRCDIR to the"
	    echo "top directory in the samhain source tree."
	    exit 1
	fi
    fi
fi

export SCRIPTDIR

PW_DIR=`pwd`; export PW_DIR

if test x$1 = x1; then
    exec ${SCRIPTDIR}/testcompile.sh
fi
if test x$1 = x2; then
    exec ${SCRIPTDIR}/testhash.sh
fi
if test x$1 = x3; then
    exec ${SCRIPTDIR}/testrun_1.sh
fi
if test x$1 = x4; then
    exec ${SCRIPTDIR}/testrun_1a.sh
fi
if test x$1 = x5; then
    exec ${SCRIPTDIR}/testext.sh
fi
if test x$1 = x6; then
    exec ${SCRIPTDIR}/testtimesrv.sh
fi
if test x$1 = x7; then
    exec ${SCRIPTDIR}/testrun_1b.sh
fi
if test x$1 = x10; then
    exec ${SCRIPTDIR}/testrun_2.sh $2
fi
if test x$1 = x11; then
    exec ${SCRIPTDIR}/testrun_2a.sh $2
fi
if test x$1 = x12; then
    exec ${SCRIPTDIR}/testrun_2b.sh $2
fi
if test x$1 = x13; then
    exec ${SCRIPTDIR}/testrun_2c.sh $2
fi
if test x$1 = x14; then
    exec ${SCRIPTDIR}/testrun_2d.sh $2
fi
if test x$1 = xall; then
    ${SCRIPTDIR}/testcompile.sh
    ${SCRIPTDIR}/testhash.sh
    ${SCRIPTDIR}/testrun_1.sh
    ${SCRIPTDIR}/testrun_1a.sh
    ${SCRIPTDIR}/testext.sh
    ${SCRIPTDIR}/testtimesrv.sh
    ${SCRIPTDIR}/testrun_1b.sh
    ${SCRIPTDIR}/testrun_2.sh $2
    ${SCRIPTDIR}/testrun_2a.sh $2
fi

echo "Usage (in brackets: config files used):"
echo
echo "  ${S}test.sh 1${E}            -- Compilation with many different options"
echo "  ${S}test.sh 2${E}            -- Hash function"
echo "  ${S}test.sh 3${E}            -- Standalone init/check    (testrc_1)"
echo "  ${S}test.sh 4${E}            -- Microstealth init/check  (testrc_1)"
echo "  ${S}test.sh 5${E}            -- External program call    (testrc_1ext.in)"
echo "  ${S}test.sh 6${E}            -- Timeserver option        (testrc_1)"
echo "  ${S}test.sh 7${E}            -- GnuPG signed files       (testrc_1)"
#
#
#
echo "  ${S}test.sh 10 hostname${E}  -- Test c/s init/check      (testrc_2.in)"
echo "  ${S}test.sh 11 hostname${E}  -- Test full c/s init/check (testrc_2.in)"
echo "  ${S}test.sh 12 hostname${E}  -- Test full c/s w/gpg      (testrc_2.in)"
echo "  ${S}test.sh 13 hostname${E}  -- Test full c/s w/mysql    (testrc_2.in)"
echo "  ${S}test.sh 14 hostname${E}  -- Test c/s w/syslog logging(testrc_2.in)"
echo "  ${S}test.sh a  hostname${E}  -- All except 7,12+"

echo 
echo "Scripts used: (1) ./testcompile.sh  (2) ./testhash.sh    (3) ./testrun_1.sh"
echo "              (4) ./testrun_1a.sh   (5) ./testext.sh     (6) ./testtimesrv.sh"
echo "              (7) ./testrun_1b.sh  (10) ./testrun_2.sh  (11) ./testrun_2a.sh"
echo "             (12) ./testrun_2b.sh  (13) ./testrun_2c.sh (14) ./testrun_2d.sh"

