#ifndef SH_TRACE_H
#define SH_TRACE_H


/* This file should be included via samhain.h only.
 */
#ifdef SL_DEBUG
#define SDG_0RETU _("return.\n")
#define SDG_TERRO _("ERROR: file=<%s>, line=<%d>, reason=<%s>\n")
#define SDG_AERRO _("ERROR: file=<%s>, line=<%d>, failed_assertion=<%s>\n")
#define SDG_AFAIL _("FAILED: file=<%s>, line=<%d>, assertion=<%s>\n")
#define SDG_ENTER _("enter=<%s>\n")
#define SDG_RETUR _("return=<%s>.\n")
#define SDG_ERROR _("error=<%ld>.\n")
#endif

#ifdef SL_DEBUG
#define ASSERT(expr, expr1) \
      if (!(expr)) \
	{ \
         fprintf(stderr,	    \
		 SDG_AERRO, \
		 FIL__, __LINE__, expr1 ); \
          abort(); \
	}


#define ASSERT_RET(expr, expr1, rr) \
      if (!(expr)) \
        { \
         fprintf(stderr, \
		 SDG_AERRO, \
		 FIL__, __LINE__, expr1 ); \
         TPT(( (-1), FIL__, __LINE__, SDG_0RETU))      \
         return (rr); \
        }
#else
#define ASSERT(expr, expr1)
  
#define ASSERT_RET(expr, expr1, rr) \
      if (!(expr)) return (rr);
#endif


#ifdef SL_DEBUG
#define TX1(expr1) \
  fprintf(stderr, \
	SDG_TERRO, \
		 FIL__, __LINE__, expr1 ); 
#else
#define TX1(expr1)
#endif

/* #ifndef SH_TRACE_H */
#endif

