dnl aclocal.m4 generated automatically by aclocal 1.3

dnl Copyright (C) 1994, 1995, 1996, 1997, 1998 Free Software Foundation, Inc.
dnl This Makefile.in is free software; the Free Software Foundation
dnl gives unlimited permission to copy and/or distribute it,
dnl with or without modifications, as long as this notice is preserved.

dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY, to the extent permitted by law; without
dnl even the implied warranty of MERCHANTABILITY or FITNESS FOR A
dnl PARTICULAR PURPOSE.

#
# Check to make sure that the build environment is sane.
#
AC_DEFUN([AM_INIT_AUTOMAKE],
[
AC_REQUIRE([AC_PROG_INSTALL])
PACKAGE=[$1]
AC_SUBST(PACKAGE)
VERSION=[$2]
AC_SUBST(VERSION)
dnl test to see if srcdir already configured
if test "`cd $srcdir && pwd`" != "`pwd`" && test -f $srcdir/config.status; then
  AC_MSG_ERROR([source directory already configured; run "make distclean" there first])
fi
ifelse([$3],,
AC_DEFINE_UNQUOTED(PACKAGE, "$PACKAGE")
AC_DEFINE_UNQUOTED(VERSION, "$VERSION"))
AC_REQUIRE([AC_PROG_MAKE_SET])])


# Define a conditional.

AC_DEFUN([AM_CONDITIONAL],
[AC_SUBST($1_TRUE)
AC_SUBST($1_FALSE)
if $2; then
  $1_TRUE=
  $1_FALSE='#'
else
  $1_TRUE='#'
  $1_FALSE=
fi])


AC_DEFUN([sh_run_prog],
[if test "$cross_compiling" = "yes"; then
   AC_MSG_ERROR([Can not probe non-portable values when cross compiling])
fi
cat > conftest.$ac_ext <<EOF
[#]line __oline__ "configure"
#include "confdefs.h"
ifelse(AC_LANG, CPLUSPLUS, [#ifdef __cplusplus
extern "C" void exit(int);
#endif
])
[$1]
EOF
if AC_TRY_EVAL(ac_link) && test -s conftest && $2=`(./conftest 2>/dev/null)`
then
dnl Don't remove the temporary files here, so they can be examined.
ifelse([$3], , :, [$3])
else
echo "configure: failed program was:" >&AC_FD_CC
cat conftest.$ac_ext >&AC_FD_CC
ifelse([$4], , , [  rm -fr conftest*
  $4
])
fi
rm -fr conftest* ])

dnl fs type number of the proc filing system
AC_DEFUN([sh_procfs_id],
[AC_MSG_CHECKING([f_type of /proc])
AC_CACHE_VAL([sh_cv_proc_fstype],
[sh_run_prog(
changequote(<<, >>)dnl
<<#include <stdio.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif /* HAVE_STDLIB_H */
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif /* HAVE_UNISTD_H */
#ifdef HAVE_SYS_VFS_H
#include <sys/vfs.h>
#endif
#ifndef Q
#define __Q(x) #x
#define Q(x) __Q(x)
#endif
int main(void)
{
struct statfs fsbuf;
long ft;
if (statfs("/", &fsbuf)!=0)
  exit(1);
ft=fsbuf.f_type;
if (statfs("/proc/1", &fsbuf)!=0)
  exit(1);
if (ft!=fsbuf.f_type)
  printf("0x%08lx", fsbuf.f_type);
else
  puts("statfs useless");
exit(0);
} >>
changequote([, ]), sh_cv_proc_fstype,, sh_cv_proc_fstype="a fatal error occured")])
AC_MSG_RESULT($sh_cv_proc_fstype)
if test "${sh_cv_proc_fstype}" = "a fatal error occured"; then
  $1=$2
  $4
else if test "${sh_cv_proc_fstype}" = "statfs useless"; then
  $1=$2
  $4
else
  $1=$sh_cv_proc_fstype
  $3
fi; fi ])

# Check whether mlock is broken (hpux 10.20 raises a SIGBUS if mlock
# is not called from uid 0 (not tested whether uid 0 works)
dnl AC_CHECK_MLOCK
dnl
define([AC_CHECK_MLOCK],
  [ AC_CHECK_FUNCS(mlock)
    if test "$ac_cv_func_mlock" = "yes"; then
        AC_MSG_CHECKING(whether mlock is broken)
          AC_CACHE_VAL(ac_cv_have_broken_mlock,
             AC_TRY_RUN([
                #include <stdlib.h>
                #include <unistd.h>
                #include <errno.h>
                #include <sys/mman.h>
                #include <sys/types.h>
                #include <fcntl.h>

                int main()
                {
                    char *pool;
                    int err;
                    long int pgsize = getpagesize();

                    pool = malloc( 4096 + pgsize );
                    if( !pool )
                        return 2;
                    pool += (pgsize - ((long int)pool % pgsize));

                    err = mlock( pool, 4096 );
                    if( !err || errno == EPERM )
                        return 0; /* okay */

                    return 1;  /* hmmm */
                }

            ],
            ac_cv_have_broken_mlock="no",
            ac_cv_have_broken_mlock="yes",
            ac_cv_have_broken_mlock="assume-no"
           )
         )
         if test "$ac_cv_have_broken_mlock" = "yes"; then
             AC_DEFINE(HAVE_BROKEN_MLOCK)
             AC_MSG_RESULT(yes)
         else
            if test "$ac_cv_have_broken_mlock" = "no"; then
                AC_MSG_RESULT(no)
            else
                AC_MSG_RESULT(assuming no)
            fi
         fi
    fi
  ])

dnl @synopsis AC_FUNC_VSNPRINTF
dnl
dnl Check whether there is a reasonably sane vsnprintf() function installed.
dnl "Reasonably sane" in this context means never clobbering memory beyond
dnl the buffer supplied, and having a sensible return value.  It is
dnl explicitly allowed not to NUL-terminate the return value, however.
dnl
dnl @version $Id: ac_func_vsnprintf.m4,v 1.1 2001/07/26 02:00:21 guidod Exp $
dnl @author Gaute Strokkenes <gs234@cam.ac.uk>
dnl
AC_DEFUN([SL_CHECK_VSNPRINTF],
[AC_CACHE_CHECK(for working vsnprintf,
  ac_cv_func_vsnprintf,
[AC_TRY_RUN(
[#include <stdio.h>
#include <stdarg.h>

int
doit(char * s, ...)
{
  char buffer[32];
  va_list args;
  int r;

  buffer[5] = 'X';

  va_start(args, s);
  r = vsnprintf(buffer, 5, s, args);
  va_end(args);

  /* -1 is pre-C99, 7 is C99. R.W. 17.01.2003 disallow -1 */

  if (r != 7)
    exit(1);

  /* We deliberately do not care if the result is NUL-terminated or
     not, since this is easy to work around like this.  */

  buffer[4] = 0;

  /* Simple sanity check.  */

  if (strcmp(buffer, "1234"))
    exit(1);

  if (buffer[5] != 'X')
    exit(1);

  exit(0);
}

int
main(void)
{
  doit("1234567");
  exit(1);
}], ac_cv_func_vsnprintf=yes, ac_cv_func_vsnprintf=no, ac_cv_func_vsnprintf=no)])
dnl Note that the default is to be pessimistic in the case 
dnl of cross compilation.
dnl If you know that the target has a sensible vsnprintf(), 
dnl you can get around this
dnl by setting ac_func_vsnprintf to yes, as described in the Autoconf manual.
if test $ac_cv_func_vsnprintf = yes; then
  :
else
  AC_DEFINE(HAVE_BROKEN_VSNPRINTF, 1,
            [Define if you have a broken version of the `vsnprintf' function.])
fi
])# AC_FUNC_VSNPRINTF

dnl SH_CHECK_TYPEDEF(TYPE, HAVE_NAME)
dnl Check whether a typedef exists and create a #define $2 if it exists
dnl
AC_DEFUN([SH_CHECK_TYPEDEF],
  [ AC_MSG_CHECKING(for $1 typedef)
    sh_cv_typedef_foo=`echo sh_cv_typedef_$1 | sed -e 's% %_%g'`
    AC_CACHE_VAL( $sh_cv_typedef_foo,
    [AC_TRY_COMPILE([#include <stdlib.h>
    #include <sys/types.h>], [
    #undef $1
    int a = sizeof($1);
    ], sh_cv_typedef=yes, sh_cv_typedef=no )])
    AC_MSG_RESULT($sh_cv_typedef)
    if test "$sh_cv_typedef" = yes; then
        AC_DEFINE($2)
	sh_$2=yes
    else
	sh_$2=no
    fi
  ])



dnl **********************
dnl *** va_copy checks ***
dnl **********************
AC_DEFUN([SL_CHECK_VA_COPY],
[AC_MSG_CHECKING(for va_copy())
AC_CACHE_VAL(sh_cv_va_copy,[
        AC_TRY_RUN([
        #include <stdarg.h>
        void f (int i, ...) {
        va_list args1, args2;
        va_start (args1, i);
        va_copy (args2, args1);
        if (va_arg (args2, int) != 42)
	  exit (1);
	if (va_arg (args1, int) != 42)
          exit (1);
        va_end (args1); va_end (args2);
        }
        int main() {
          f (0, 42);
          return 0;
        }],
        sh_cv_va_copy=yes
        ,
        sh_cv_va_copy=no
        ,
	sh_cv_va_copy=no)
])
AC_MSG_RESULT($sh_cv_va_copy)
AC_MSG_CHECKING(for __va_copy())
AC_CACHE_VAL(sh_cv___va_copy,[
        AC_TRY_RUN([
        #include <stdarg.h>
        void f (int i, ...) {
        va_list args1, args2;
        va_start (args1, i);
        __va_copy (args2, args1);
        if (va_arg (args2, int) != 42)
	  exit (1);
	if (va_arg (args1, int) != 42)
          exit (1);
        va_end (args1); va_end (args2);
        }
        int main() {
          f (0, 42);
          return 0;
        }],
        sh_cv___va_copy=yes
        ,
        sh_cv___va_copy=no
        ,
	sh_cv___va_copy=no)
])
AC_MSG_RESULT($sh_cv___va_copy)
AC_MSG_CHECKING(whether va_lists can be copied by value)
AC_CACHE_VAL(sh_cv_va_val_copy,[
        AC_TRY_RUN([
        #include <stdarg.h>
        void f (int i, ...) {
        va_list args1, args2;
        va_start (args1, i);
        args2 = args1;
        if (va_arg (args2, int) != 42)
	  exit (1);
	if (va_arg (args1, int) != 42)
          exit (1);
        va_end (args1); va_end (args2);
        }
        int main() {
          f (0, 42);
          return 0;
        }],
        sh_cv_va_val_copy=yes
        ,
        sh_cv_va_val_copy=no
        ,
	sh_cv_va_val_copy=no)
])
if test "x$sh_cv_va_copy" = "xyes"; then
  AC_DEFINE(VA_COPY, va_copy)
else if test "x$sh_cv___va_copy" = "xyes"; then
  AC_DEFINE(VA_COPY, __va_copy)
fi
fi
if test "x$sh_cv_va_val_copy" = "xno"; then
  AC_DEFINE(VA_COPY_AS_ARRAY)
fi
AC_MSG_RESULT($sh_cv_va_val_copy)
])


dnl SH_INIT_PARSE_ARGS()
m4_define([SH_INIT_PARSE_ARGS],
[
m4_divert_push([PARSE_ARGS])dnl

as_cr_letters='abcdefghijklmnopqrstuvwxyz'
as_cr_LETTERS='ABCDEFGHIJKLMNOPQRSTUVWXYZ'
as_cr_Letters=$as_cr_letters$as_cr_LETTERS
as_cr_digits='0123456789'
as_cr_alnum=$as_cr_Letters$as_cr_digits

# Sed expression to map a string onto a valid CPP name.
as_tr_cpp="sed y%*$as_cr_letters%P$as_cr_LETTERS%;s%[[^_$as_cr_alnum]]%_%g"

as_tr_sh="eval sed 'y%*+%pp%;s%[[^_$as_cr_alnum]]%_%g'"
# IFS
# We need space, tab and new line, in precisely that order.
as_nl='
'
IFS=" 	$as_nl"

# CDPATH.
$as_unset CDPATH || test "${CDPATH+set}" != set || { CDPATH=$PATH_SEPARATOR; export CDPATH; }


# Initialize some variables set by options.
ac_init_help=
ac_init_version=false
# The variables have the same names as the options, with
# dashes changed to underlines.
cache_file=/dev/null
AC_SUBST(exec_prefix, NONE)dnl
no_create=
no_recursion=
AC_SUBST(prefix, NONE)dnl
program_prefix=NONE
program_suffix=NONE
AC_SUBST(program_transform_name, [s,x,x,])dnl
silent=
site=
srcdir=
verbose=
x_includes=NONE
x_libraries=NONE
DESTDIR=
SH_ENABLE_OPTS="db-reload xml-log message-queue login-watch mounts-check userfiles debug ptrace static network udp nocl stealth micro-stealth install-name identity khide suidcheck base largefile mail external-scripts encrypt srp"
SH_WITH_OPTS="prelude libprelude-prefix database libwrap cflags libs console altconsole timeserver alttimeserver rnd egd-socket port logserver altlogserver kcheck gpg checksum fp recipient sender trusted tmp-dir config-file log-file pid-file state-dir data-file html-file"

# Installation directory options.
# These are left unexpanded so users can "make install exec_prefix=/foo"
# and all the variables that are supposed to be based on exec_prefix
# by default will actually change.
dnl Use braces instead of parens because sh, perl, etc. also accept them.
sbindir='${exec_prefix}/sbin'
sysconfdir='${prefix}/etc'
localstatedir='${prefix}/var'
mandir='${prefix}/share/man'

AC_SUBST([sbindir],        ['${exec_prefix}/sbin'])dnl
AC_SUBST([sysconfdir],     ['${prefix}/etc'])dnl
AC_SUBST([localstatedir],  ['${prefix}/var'])dnl
AC_SUBST([mandir],         ['${prefix}/share/man'])dnl


# Initialize some other variables.
subdirs=
MFLAGS= MAKEFLAGS=
SHELL=${CONFIG_SHELL-/bin/sh}
# Maximum number of lines to put in a shell here document.
ac_max_here_lines=12

ac_prev=
for ac_option
do

  # If the previous option needs an argument, assign it.
  if test -n "$ac_prev"; then
    eval "$ac_prev=\$ac_option"
    ac_prev=
    continue
  fi

  case "$ac_option" in
changequote(, )dnl
  *=*) ac_optarg=`echo "$ac_option" | sed 's/[-_a-zA-Z0-9]*=//'` ;;
changequote([, ])dnl
  *) ac_optarg= ;;
  esac

  # Accept the important Cygnus configure options, so we can diagnose typos.

  case "$ac_option" in

  -build | --build | --buil | --bui | --bu)
    ac_prev=build_alias ;;
  -build=* | --build=* | --buil=* | --bui=* | --bu=*)
    build_alias="$ac_optarg" ;;

  -cache-file | --cache-file | --cache-fil | --cache-fi \
  | --cache-f | --cache- | --cache | --cach | --cac | --ca | --c)
    ac_prev=cache_file ;;
  -cache-file=* | --cache-file=* | --cache-fil=* | --cache-fi=* \
  | --cache-f=* | --cache-=* | --cache=* | --cach=* | --cac=* | --ca=* | --c=*)
    cache_file="$ac_optarg" ;;

  --config-cache | -C)
    cache_file=config.cache ;;

  -disable-* | --disable-*)
    ac_feature=`expr "x$ac_option" : 'x-*disable-\(.*\)'`
    # Reject names that are not valid shell variable names.
    expr "x$ac_feature" : "[.*[^-_$as_cr_alnum]]" >/dev/null &&
      AC_MSG_ERROR([invalid feature name: $ac_feature])
    ac_feature=`echo $ac_feature | sed 's/-/_/g'`
    ac_enable_check_opt=no
    for f in ${SH_ENABLE_OPTS}
    do
	f=`echo $f | sed 's/-/_/g'`
	if test x${f} = x"${ac_feature}"
	then
		ac_enable_check_opt=yes
	fi
    done
    if test x${ac_enable_check_opt} = xno
    then
	AC_MSG_ERROR([unrecognized option: $ac_option
Try `$[0] --help' for more information.])
    fi
    eval "enable_$ac_feature=no" ;;

  -enable-* | --enable-*)
    ac_feature=`expr "x$ac_option" : 'x-*enable-\([[^=]]*\)'`
    # Reject names that are not valid shell variable names.
    expr "x$ac_feature" : "[.*[^-_$as_cr_alnum]]" >/dev/null &&
      AC_MSG_ERROR([invalid feature name: $ac_feature])
    ac_feature=`echo $ac_feature | sed 's/-/_/g'`
    case $ac_option in
      *=*) ac_optarg=`echo "$ac_optarg" | sed "s/'/'\\\\\\\\''/g"`;;
      *) ac_optarg=yes ;;
    esac
    ac_enable_check_opt=no
    for f in ${SH_ENABLE_OPTS}
    do
	f=`echo $f | sed 's/-/_/g'`
	if test x${f} = x"${ac_feature}"
	then
		ac_enable_check_opt=yes
	fi
    done
    if test x${ac_enable_check_opt} = xno
    then
	AC_MSG_ERROR([unrecognized option: $ac_option
Try `$[0] --help' for more information.])
    fi
    eval "enable_$ac_feature='$ac_optarg'" ;;

  -exec-prefix | --exec_prefix | --exec-prefix | --exec-prefi \
  | --exec-pref | --exec-pre | --exec-pr | --exec-p | --exec- \
  | --exec | --exe | --ex)
    ac_prev=exec_prefix 
    ac_exec_prefix_set="yes"
    ;;
  -exec-prefix=* | --exec_prefix=* | --exec-prefix=* | --exec-prefi=* \
  | --exec-pref=* | --exec-pre=* | --exec-pr=* | --exec-p=* | --exec-=* \
  | --exec=* | --exe=* | --ex=*)
    exec_prefix="$ac_optarg" 
    ac_exec_prefix_set="yes"
    ;;

  -gas | --gas | --ga | --g)
    # Obsolete; use --with-gas.
    with_gas=yes ;;

  -help | --help | --hel | --he | -h)
    ac_init_help=long ;;
  -help=r* | --help=r* | --hel=r* | --he=r* | -hr*)
    ac_init_help=recursive ;;
  -help=s* | --help=s* | --hel=s* | --he=s* | -hs*)
    ac_init_help=short ;;

  -host | --host | --hos | --ho)
    ac_prev=host_alias ;;
  -host=* | --host=* | --hos=* | --ho=*)
    host_alias="$ac_optarg" ;;

  -localstatedir | --localstatedir | --localstatedi | --localstated \
  | --localstate | --localstat | --localsta | --localst \
  | --locals | --local | --loca | --loc | --lo)
    ac_prev=localstatedir 
    ac_localstatedir_set="yes"
    ;;
  -localstatedir=* | --localstatedir=* | --localstatedi=* | --localstated=* \
  | --localstate=* | --localstat=* | --localsta=* | --localst=* \
  | --locals=* | --local=* | --loca=* | --loc=* | --lo=*)
    localstatedir="$ac_optarg" 
    ac_localstatedir_set="yes"
    ;;

  -mandir | --mandir | --mandi | --mand | --man | --ma | --m)
    ac_prev=mandir 
    ac_mandir_set="yes"
    ;;
  -mandir=* | --mandir=* | --mandi=* | --mand=* | --man=* | --ma=* | --m=*)
    mandir="$ac_optarg" 
    ac_mandir_set="yes"
    ;;

  -nfp | --nfp | --nf)
    # Obsolete; use --without-fp.
    with_fp=no ;;

  -no-create | --no-create | --no-creat | --no-crea | --no-cre \
  | --no-cr | --no-c | -n)
    no_create=yes ;;

  -no-recursion | --no-recursion | --no-recursio | --no-recursi \
  | --no-recurs | --no-recur | --no-recu | --no-rec | --no-re | --no-r)
    no_recursion=yes ;;

  -prefix | --prefix | --prefi | --pref | --pre | --pr | --p)
    ac_prev=prefix
    ac_prefix_set="yes" 
    ;;
  -prefix=* | --prefix=* | --prefi=* | --pref=* | --pre=* | --pr=* | --p=*)
    prefix="$ac_optarg" 
    ac_prefix_set="yes" 
    ;;

  -q | -quiet | --quiet | --quie | --qui | --qu | --q \
  | -silent | --silent | --silen | --sile | --sil)
    silent=yes ;;

  -sbindir | --sbindir | --sbindi | --sbind | --sbin | --sbi | --sb)
    ac_prev=sbindir 
    ac_sbindir_set="yes" 
    ;;
  -sbindir=* | --sbindir=* | --sbindi=* | --sbind=* | --sbin=* \
  | --sbi=* | --sb=*)
    sbindir="$ac_optarg" 
    ac_sbindir_set="yes" 
    ;;

  -bindir | --bindir | --bindi | --bind | --bin | --bi | --b)
    echo "WARNING: bindir will be ignored, use sbindir" 
    ;;
  -bindir=* | --bindir=* | --bindi=* | --bind=* | --bin=* \
  | --bi=* | --b=*)
    echo "WARNING: bindir will be ignored, use sbindir" 
    ;;

  -datadir | --datadir)
    echo "WARNING: datadir will be ignored" 
   ;;
  -datadir=* | --datadir=*)
    echo "WARNING: datadir will be ignored" 
   ;;
 
  -includedir | --includedir)
    echo "WARNING: includedir will be ignored" 
   ;;
  -includedir=* | --includedir=*)
    echo "WARNING: includedir will be ignored" 
   ;;

  -infodir | --infodir)
    echo "WARNING: infodir will be ignored" 
   ;;
  -infodir=* | --infodir=*)
    echo "WARNING: infodir will be ignored" 
   ;;
 
  -libdir | --libdir)
    echo "WARNING: libdir will be ignored" 
   ;;
  -libdir=* | --libdir=*)
    echo "WARNING: libdir will be ignored" 
   ;;
 
  -libexecdir | --libexecdir)
    echo "WARNING: libexecdir will be ignored" 
   ;;
  -libexecdir=* | --libexecdir=*)
    echo "WARNING: libexecdir will be ignored" 
   ;;

  -sharedstatedir | --sharedstatedir)
    echo "WARNING: sharedstatedir will be ignored" 
   ;;
  -sharedstatedir=* | --sharedstatedir=*)
    echo "WARNING: sharedstatedir will be ignored" 
   ;;
 
  -site | --site | --sit)
    ac_prev=site ;;
  -site=* | --site=* | --sit=*)
    site="$ac_optarg" ;;

  -srcdir | --srcdir | --srcdi | --srcd | --src | --sr)
    ac_prev=srcdir ;;
  -srcdir=* | --srcdir=* | --srcdi=* | --srcd=* | --src=* | --sr=*)
    srcdir="$ac_optarg" ;;

  -sysconfdir | --sysconfdir | --sysconfdi | --sysconfd | --sysconf \
  | --syscon | --sysco | --sysc | --sys | --sy)
    ac_prev=sysconfdir 
    ac_sysconfdir_set="yes" 
    ;;
  -sysconfdir=* | --sysconfdir=* | --sysconfdi=* | --sysconfd=* | --sysconf=* \
  | --syscon=* | --sysco=* | --sysc=* | --sys=* | --sy=*)
    sysconfdir="$ac_optarg" 
    ac_sysconfdir_set="yes" 
    ;;

  -target | --target | --targe | --targ | --tar | --ta | --t)
    ac_prev=target_alias ;;
  -target=* | --target=* | --targe=* | --targ=* | --tar=* | --ta=* | --t=*)
    target_alias="$ac_optarg" ;;

  -v | -verbose | --verbose | --verbos | --verbo | --verb)
    verbose=yes ;;

  -version | --version | --versio | --versi | --vers)
    ac_init_version=: ;;


  -with-* | --with-*)
    ac_package=`expr "x$ac_option" : 'x-*with-\([[^=]]*\)'`
    # Reject names that are not valid shell variable names.
    expr "x$ac_package" : "[.*[^-_$as_cr_alnum]]" >/dev/null &&
      AC_MSG_ERROR([invalid package name: $ac_package])
    ac_package=`echo $ac_package| sed 's/-/_/g'`
    case $ac_option in
      *=*) ac_optarg=`echo "$ac_optarg" | sed "s/'/'\\\\\\\\''/g"`;;
      *) ac_optarg=yes ;;
    esac
    ac_with_check_opt=no
    for f in ${SH_WITH_OPTS}
    do
	f=`echo $f | sed 's/-/_/g'`
	if test x${f} = x"${ac_package}"
	then
		ac_with_check_opt=yes
	fi
    done
    if test x${ac_with_check_opt} = xno
    then
	AC_MSG_ERROR([unrecognized option: $ac_option
Try `$[0] --help' for more information.])
    fi
    eval "with_$ac_package='$ac_optarg'" ;;

  -without-* | --without-*)
    ac_package=`expr "x$ac_option" : 'x-*without-\(.*\)'`
    # Reject names that are not valid shell variable names.
    expr "x$ac_package" : "[.*[^-_$as_cr_alnum]]" >/dev/null &&
      AC_MSG_ERROR([invalid package name: $ac_package])
    ac_package=`echo $ac_package | sed 's/-/_/g'`
    ac_with_check_opt=no
    for f in ${SH_WITH_OPTS}
    do
	f=`echo $f | sed 's/-/_/g'`
	if test x${f} = x"${ac_package}"
	then
		ac_with_check_opt=yes
	fi
    done
    if test x${ac_with_check_opt} = xno
    then
	AC_MSG_ERROR([unrecognized option: $ac_option
Try `$[0] --help' for more information.])
    fi
    eval "with_$ac_package=no" ;;


  -*) AC_MSG_ERROR([unrecognized option: $ac_option
Try `$[0] --help' for more information.])
    ;;

  *=*)
    ac_envvar=`expr "x$ac_option" : 'x\([[^=]]*\)='`
    # Reject names that are not valid shell variable names.
    expr "x$ac_envvar" : "[.*[^_$as_cr_alnum]]" >/dev/null &&
      AC_MSG_ERROR([invalid variable name: $ac_envvar])
    ac_optarg=`echo "$ac_optarg" | sed "s/'/'\\\\\\\\''/g"`
    eval "$ac_envvar='$ac_optarg'"
    export $ac_envvar ;;

  *)
    # FIXME: should be removed in autoconf 3.0.
    AC_MSG_WARN([you should use --build, --host, --target])
    expr "x$ac_option" : "[.*[^-._$as_cr_alnum]]" >/dev/null &&
      AC_MSG_WARN([invalid host type: $ac_option])
    : ${build_alias=$ac_option} ${host_alias=$ac_option} ${target_alias=$ac_option}
    ;;


  esac
done

if test -n "$ac_prev"; then
  AC_MSG_ERROR(missing argument to --`echo $ac_prev | sed 's/_/-/g'`)
fi

# Be sure to have absolute paths.
for ac_var in prefix exec_prefix
do
  eval ac_val=$`echo $ac_var`
  case $ac_val in
    [[\\/$]]* | ?:[[\\/]]* | NONE | '' | OPT | USR ) ;;
    *)  AC_MSG_ERROR([expected an absolute directory name for --$ac_var: $ac_val]);;
  esac
done

# Be sure to have absolute paths.
for ac_var in sbindir sysconfdir localstatedir mandir
do
  eval ac_val=$`echo $ac_var`
  case $ac_val in
    [[\\/$]]* | ?:[[\\/]]* ) ;;
    *)  AC_MSG_ERROR([expected an absolute directory name for --$ac_var: $ac_val]);;
  esac
done

# There might be people who depend on the old broken behavior: `$host'
# used to hold the argument of --host etc.
# FIXME: To remove some day.
build=$build_alias
host=$host_alias
target=$target_alias

# FIXME: To remove some day.
if test "x$host_alias" != x; then
  if test "x$build_alias" = x; then
    cross_compiling=maybe
    AC_MSG_WARN([If you wanted to set the --build type, don't use --host.
    If a cross compiler is detected then cross compile mode will be used.])
  elif test "x$build_alias" != "x$host_alias"; then
    cross_compiling=yes
  fi
fi

ac_tool_prefix=
test -n "$host_alias" && ac_tool_prefix=$host_alias-

test "$silent" = yes && exec AS_MESSAGE_FD>/dev/null

m4_divert_pop([PARSE_ARGS])dnl
])# SH_INIT_PARSE_ARGS

m4_define([SH_INIT_HELP],
[m4_divert_push([HELP_BEGIN])dnl

#
# Report the --help message.
#
if test "$ac_init_help" = "long"; then
  # Omit some internal or obsolete options to make the list less imposing.
  # This message is too long to be a string in the A/UX 3.1 sh.
  cat <<_ACEOF
\`configure' configures m4_ifset([AC_PACKAGE_STRING],
                        [AC_PACKAGE_STRING],
                        [this package]) to adapt to many kinds of systems.

Usage: $[0] [[OPTION]]... [[VAR=VALUE]]...

[To assign environment variables (e.g., CC, CFLAGS...), specify them as
VAR=VALUE.  See below for descriptions of some of the useful variables.

Defaults for the options are specified in brackets.

Configuration:
  -h, --help              display this help and exit
      --help=short        display options specific to this package
      --help=recursive    display the short help of all the included packages
  -V, --version           display version information and exit
  -q, --quiet, --silent   do not print \`checking...' messages
      --cache-file=FILE   cache test results in FILE [disabled]
  -C, --config-cache      alias for \`--cache-file=config.cache'
  -n, --no-create         do not create output files
      --srcdir=DIR        find the sources in DIR [configure dir or \`..']

_ACEOF

  cat <<_ACEOF
Installation directories:
  --prefix=PREFIX         install architecture-independent files in PREFIX
                          [$ac_default_prefix]
  --exec-prefix=EPREFIX   install architecture-dependent files in EPREFIX
                          [PREFIX]

By default, \`make install' will install binaries in \`/usr/local/sbin',
the config file in \`/etc', manpage in \`/usr/local/share/man', and state
data in \`/var/lib/INSTALL_NAME' (FSH layout).  You can specify other
FSH compliant layouts with \`--prefix=OPT' or \`--prefix=USR', or you
can specify a directory with \`--prefix=DIR' to install in \`DIR/sbin',
\`DIR/etc', etc.

For better control, use the options below.

Fine tuning of the installation directories:
  --sbindir=DIR          system admin executables [EPREFIX/sbin]
  --sysconfdir=DIR       read-only single-machine data [PREFIX/etc]
  --localstatedir=DIR    modifiable single-machine data [PREFIX/var]
  --mandir=DIR           man documentation [PREFIX/man]

For even finer tuning, paths can be specified for individual files (see below)

_ACEOF

  cat <<\_ACEOF]
m4_divert_pop([HELP_BEGIN])dnl
dnl The order of the diversions here is
dnl - HELP_BEGIN
dnl   which may be prolongated by extra generic options such as with X or
dnl   AC_ARG_PROGRAM.  Displayed only in long --help.
dnl
dnl - HELP_CANON
dnl   Support for cross compilation (--build, --host and --target).
dnl   Display only in long --help.
dnl
dnl - HELP_ENABLE
dnl   which starts with the trailer of the HELP_BEGIN, HELP_CANON section,
dnl   then implements the header of the non generic options.
dnl
dnl - HELP_WITH
dnl
dnl - HELP_VAR
dnl
dnl - HELP_VAR_END
dnl
dnl - HELP_END
dnl   initialized below, in which we dump the trailer (handling of the
dnl   recursion for instance).
m4_divert_push([HELP_ENABLE])dnl
_ACEOF
fi

if test -n "$ac_init_help"; then
m4_ifset([AC_PACKAGE_STRING],
[  case $ac_init_help in
     short | recursive ) echo "Configuration of AC_PACKAGE_STRING:";;
   esac])
  cat <<\_ACEOF
m4_divert_pop([HELP_ENABLE])dnl
m4_divert_push([HELP_END])dnl
m4_ifset([AC_PACKAGE_BUGREPORT], [
Report bugs to <AC_PACKAGE_BUGREPORT>.])
_ACEOF
fi

if test "$ac_init_help" = "recursive"; then
  # If there are subdirs, report their specific --help.
  ac_popdir=`pwd`
  for ac_dir in : $ac_subdirs_all; do test "x$ac_dir" = x: && continue
    test -d $ac_dir || continue
    _AC_SRCPATHS(["$ac_dir"])
    cd $ac_dir
    # Check for guested configure; otherwise get Cygnus style configure.
    if test -f $ac_srcdir/configure.gnu; then
      echo
      $SHELL $ac_srcdir/configure.gnu  --help=recursive
    elif test -f $ac_srcdir/configure; then
      echo
      $SHELL $ac_srcdir/configure  --help=recursive
    elif test -f $ac_srcdir/configure.ac ||
           test -f $ac_srcdir/configure.in; then
      echo
      $ac_configure --help
    else
      AC_MSG_WARN([no configuration information is in $ac_dir])
    fi
    cd $ac_popdir
  done
fi

test -n "$ac_init_help" && exit 0
m4_divert_pop([HELP_END])dnl
])# SH_INIT_HELP








# Check whether sa_sigaction works.
# Rainer Wichmann <support@la-samhna.de>, 2003.
#
# This file can be copied and used freely without restrictions.  It can
# be used in projects which are not available under the GNU Public License.

# serial 1

AC_DEFUN([AM_SA_SIGACTION_WORKS],
  [
   am_cv_val_SA_SIGACTION=no
   AC_CHECK_HEADER(signal.h,
     [
      AM_SI_USER
      AM_SA_SIGINFO
      if test $am_cv_val_SI_USER = yes && test $am_cv_val_SA_SIGINFO = yes
      then
        AC_TRY_RUN([
#include <signal.h>
#include <setjmp.h>
#include <stdio.h>
#include <stdlib.h>

volatile int xnum  = 0;
volatile int xcode = 0; 
jmp_buf      Buf;
int          xsig  = SIGSEGV;

void sighandler (int xsignam, siginfo_t * xsiginfo, void * xsigadd)
{
  static sigset_t x;

  if (xsiginfo == NULL)
    exit(__LINE__);
  if (xsiginfo->si_signo != xsignam)
    exit(__LINE__);
  ++xnum;
  xcode   = xsiginfo->si_code;
  sigemptyset (&x);
  sigprocmask(SIG_SETMASK, &x, NULL);
  longjmp ( Buf, 1);
}

int main ()
{
  struct sigaction newact;

  newact.sa_sigaction = sighandler;
  sigemptyset (&newact.sa_mask);
  newact.sa_flags = SA_SIGINFO;
  if (0 != sigaction (xsig, &newact, NULL))
    exit (__LINE__);
  if(setjmp ( Buf)) {
      if (xnum > 1)
	goto Third;
      goto Second;
  }
  memcpy((void *) 0x0, "test", 5);
 Second:
  if (xcode == SI_USER)
    exit (__LINE__);
  raise(xsig);
 Third:
  if (xcode != SI_USER)
    exit (__LINE__);
  if (xnum != 2)
    exit (__LINE__);
  return (0);
}], am_cv_val_SA_SIGACTION=yes, am_cv_val_SA_SIGACTION=no, am_cv_val_SA_SIGACTION=no)
   fi
      ])
     AC_MSG_CHECKING([whether sa_sigaction is supported])
     if test $am_cv_val_SA_SIGACTION = yes
     then
       AC_MSG_RESULT(yes)
       AC_DEFINE([SA_SIGACTION_WORKS], 1, [Define if sa_sigaction works])
     else
	AC_MSG_RESULT(no)
     fi
     ])

# Check whether SI_USER is available in <signal.h>.
# Rainer Wichmann <support@la-samhna.de>, 2003.
#
# This file can be copied and used freely without restrictions.  It can
# be used in projects which are not available under the GNU Public License.

# serial 1


AC_DEFUN([AM_SI_USER],
  [if test $ac_cv_header_signal_h = yes; then
    AC_CACHE_CHECK([for SI_USER in signal.h], am_cv_val_SI_USER,
      [AC_TRY_LINK([#include <signal.h>], [return SI_USER],
       am_cv_val_SI_USER=yes, am_cv_val_SI_USER=no)])
    if test $am_cv_val_SI_USER = yes; then
      AC_DEFINE([HAVE_SI_USER], 1, [Define if you have SI_USER])
    fi
  fi])

# Check whether SA_SIGINFO is available in <signal.h>.
# Rainer Wichmann <support@la-samhna.de>, 2003.
#
# This file can be copied and used freely without restrictions.  It can
# be used in projects which are not available under the GNU Public License.

# serial 1


AC_DEFUN([AM_SA_SIGINFO],
  [if test $ac_cv_header_signal_h = yes; then
    AC_CACHE_CHECK([for SA_SIGINFO in signal.h], am_cv_val_SA_SIGINFO,
      [AC_TRY_LINK([#include <signal.h>], [return SA_SIGINFO],
       am_cv_val_SA_SIGINFO=yes, am_cv_val_SA_SIGINFO=no)])
    if test $am_cv_val_SA_SIGINFO = yes; then
      AC_DEFINE([HAVE_SA_SIGINFO], 1, [Define if you have SA_SIGINFO])
    fi
  fi])

dnl
dnl Useful macros for autoconf to check for ssp-patched gcc
dnl 1.0 - September 2003 - Tiago Sousa <mirage@kaotik.org>
dnl
dnl About ssp:
dnl GCC extension for protecting applications from stack-smashing attacks
dnl http://www.research.ibm.com/trl/projects/security/ssp/
dnl
dnl Usage:
dnl After calling the correct AC_LANG_*, use the corresponding macro:
dnl
dnl GCC_STACK_PROTECT_CC
dnl checks -fstack-protector with the C compiler, if it exists then updates
dnl CFLAGS and defines ENABLE_SSP_CC
dnl
AC_DEFUN([GCC_STACK_PROTECT_CC],[
  ssp_cc=yes
  if test "X$GCC" = "Xyes"; then
    AC_MSG_CHECKING([whether ${CC} accepts -fstack-protector])
    ssp_old_cflags="$CFLAGS"
    CFLAGS="$CFLAGS -fstack-protector"
    AC_TRY_LINK(,,, ssp_cc=no)
    # echo $ssp_cc
    if test "X$ssp_cc" = "Xno"; then
      CFLAGS="$ssp_old_cflags"
      AC_MSG_RESULT(no)
    else
      AC_MSG_RESULT(yes)
      AC_DEFINE([ENABLE_SSP_CC], 1, [Define if SSP C support is enabled.])
    fi
  fi
])

AC_DEFUN([SAMHAIN_POSIX],[
	AC_MSG_CHECKING([whether _POSIX_SOURCE is necessary])
	AC_TRY_COMPILE([#include <stdio.h>
void fileno(int);int fdopen(int, char *); ],,
	[
	AC_MSG_RESULT(yes)
	AC_DEFINE([_POSIX_SOURCE],1,[Define if POSIX functions are required])
	],
	[AC_MSG_RESULT(no)])
])dnl

dnl checks for a known 64 bit programming environment
dnl AC_RUN_IFELSE(PROGRAM,
dnl               [ACTION-IF-TRUE], [ACTION-IF-FALSE],
dnl               [ACTION-IF-CROSS-COMPILING = RUNTIME-ERROR])
dnl
AC_DEFUN([SAMHAIN_PRG_ENV],[
    AC_MSG_CHECKING([for a known 64 bit programming environment])
    # Compile and run a program that determines the programming environment
    AC_RUN_IFELSE([
      AC_LANG_SOURCE([[
#include <stdio.h>
int main(int argc,char **argv)
{
  if (argc > 1) {
#if defined(__arch64__)
  printf("__arch64__\n");
#elif defined(__ia64__)
  printf("__ia64__\n");
#elif defined(__x86_64__)
  printf("__x86_64__\n");
#elif defined(__LP64__)
  printf("__LP64__\n");
#elif defined(__64BIT__)
  printf("__64BIT__\n");
#elif defined(_LP64)
  printf("_LP64\n");
#elif defined(_M_IA64)
  printf("_M_IA64\n");
#elif defined(_MIPS_SZLONG) && (_MIPS_SZLONG == 64)
  printf("_MIPS_64\n");
#else
choke me
#endif
  }
  return 0;
}
      ]])
    ],[
      # Program compiled and ran, so get version by adding argument.
      samhain_prg_ENV=`./conftest$ac_exeext x`
      samhain_64=yes
      AC_MSG_RESULT([$samhain_prg_ENV])
    ],[
      AC_MSG_RESULT([none])
	],[
      AC_MSG_RESULT([none])
	])
])dnl

AC_DEFUN([SAMHAIN_X86_64],[
	AC_MSG_CHECKING([for x86_64])
	AC_TRY_RUN([
int main() {
__asm__ volatile (
"movq %rax, %rax"
);
return 0;
}
	],
	[
	AC_MSG_RESULT(yes)
	samhain_64=yes
	tiger_src=sh_tiger1_64.c
	AC_DEFINE([TIGER_OPT_ASM],1,[Define to use tiger x86_64 optimized assembly])
	],
	[
	AC_MSG_RESULT([no])
	],[
	AC_MSG_RESULT([no])
	])
])dnl


AC_DEFUN([SAMHAIN_64],[
samhain_64=no
tiger_src=sh_tiger1.c
#
# if sizeof(unsigned long) = 4, try compiler macros for 64bit
#
if test "x$ac_cv_sizeof_unsigned_long" = x4; then
  if test "x$ac_cv_sizeof_unsigned_long_long" = x8; then
	SAMHAIN_PRG_ENV
	if test "x$samhain_64" = xyes; then
	  tiger_src=sh_tiger1_64.c
        fi
	#
	# if GCC and __i386__, use precompiled assembler
	#
	if test "x$GCC" = xyes; then
	  AC_MSG_CHECKING([for i386])
	  samhain_i386=no
	  touch conf_foo.h 
	  $CC -E -dM conf_foo.h | egrep '__i386__' >/dev/null 2>&1 && samhain_i386=yes
	  rm -f conf_foo.h
	  if test "x$samhain_i386" = xyes; then
	    tiger_src=sh_tiger1.s
	    AC_DEFINE([TIGER_32_BIT_S],1,[Define to use tiger 32 bit i386 assembler])
          fi
	  AC_MSG_RESULT([$samhain_i386])
	fi
	#
	#
	#
  else
	samhain_64=no
	tiger_src=sh_tiger1.c
  fi
else
  #
  # sizeof(unsigned long) = 8
  #
  tiger_src=sh_tiger1_64.c
  samhain_64=yes
  #
  # check for x86_64 (enables assembly optimizations)
  #
  if test "x$GCC" = xyes; then
    SAMHAIN_X86_64
  fi
fi
if test "x$samhain_64" = xyes; then 
	AC_DEFINE([TIGER_64_BIT],1,[Define to use tiger 64 bit implementation])
fi
AC_MSG_CHECKING([for 64 bit environment])
AC_MSG_RESULT([$samhain_64])
AC_MSG_CHECKING([for tiger source to use])
AC_MSG_RESULT([$tiger_src])
AC_SUBST(tiger_src)
])dnl


dnl Autoconf macros for libprelude
dnl $id$

# Modified for LIBPRELUDE -- Yoann Vandoorselaere
# Modified for LIBGNUTLS -- nmav
# Configure paths for LIBGCRYPT
# Shamelessly stolen from the one of XDELTA by Owen Taylor
# Werner Koch   99-12-09

dnl AM_PATH_LIBPRELUDE([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND ]]])
dnl Test for libprelude, and define LIBPRELUDE_PREFIX, LIBPRELUDE_CFLAGS, LIBPRELUDE_PTHREAD_CFLAGS, 
dnl LIBPRELUDE_LDFLAGS, and LIBPRELUDE_LIBS
dnl
AC_DEFUN([AM_PATH_LIBPRELUDE],
[dnl
dnl Get the cflags and libraries from the libprelude-config script
dnl
dnl AC_ARG_WITH(libprelude-prefix,
dnl          [  --with-libprelude-prefix=PFX   Prefix where libprelude is installed (optional)],
dnl          libprelude_config_prefix="$withval", libprelude_config_prefix="")
dnl
dnl  if test x$libprelude_config_prefix != x ; then
dnl     if test x${LIBPRELUDE_CONFIG+set} != xset ; then
dnl        LIBPRELUDE_CONFIG=$libprelude_config_prefix/bin/libprelude-config
dnl     fi
dnl  fi
dnl
dnl  AC_PATH_PROG(LIBPRELUDE_CONFIG, libprelude-config, no)
  min_libprelude_version=ifelse([$1], ,0.1.0,$1)
  AC_MSG_CHECKING(for libprelude - version >= $min_libprelude_version)
  no_libprelude=""
  if test "$LIBPRELUDE_CONFIG" = "no" ; then
    no_libprelude=yes
  else
    LIBPRELUDE_CFLAGS=`$LIBPRELUDE_CONFIG $libprelude_config_args --cflags`
    LIBPRELUDE_PTHREAD_CFLAGS=`$LIBPRELUDE_CONFIG $libprelude_config_args --pthread-cflags`
    LIBPRELUDE_LDFLAGS=`$LIBPRELUDE_CONFIG $libprelude_config_args --ldflags`
    LIBPRELUDE_LIBS=`$LIBPRELUDE_CONFIG $libprelude_config_args --libs`
    LIBPRELUDE_PREFIX=`$LIBPRELUDE_CONFIG $libprelude_config_args --prefix`
    LIBPRELUDE_CONFIG_PREFIX=`$LIBPRELUDE_CONFIG $libprelude_config_args --config-prefix`
    libprelude_config_version=`$LIBPRELUDE_CONFIG $libprelude_config_args --version`


      ac_save_CFLAGS="$CFLAGS"
      ac_save_LDFLAGS="$LDFLAGS"
      ac_save_LIBS="$LIBS"
      CFLAGS="$CFLAGS $LIBPRELUDE_CFLAGS"
      LDFLAGS="$LDFLAGS $LIBPRELUDE_LDFLAGS"
      LIBS="$LIBS $LIBPRELUDE_LIBS"
dnl
dnl Now check if the installed libprelude is sufficiently new. Also sanity
dnl checks the results of libprelude-config to some extent
dnl
      rm -f conf.libpreludetest
      AC_TRY_RUN([
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <libprelude/prelude.h>

int
main ()
{
    system ("touch conf.libpreludetest");

    if( strcmp( prelude_check_version(NULL), "$libprelude_config_version" ) )
    {
      printf("\n*** 'libprelude-config --version' returned %s, but LIBPRELUDE (%s)\n",
             "$libprelude_config_version", prelude_check_version(NULL) );
      printf("*** was found! If libprelude-config was correct, then it is best\n");
      printf("*** to remove the old version of LIBPRELUDE. You may also be able to fix the error\n");
      printf("*** by modifying your LD_LIBRARY_PATH enviroment variable, or by editing\n");
      printf("*** /etc/ld.so.conf. Make sure you have run ldconfig if that is\n");
      printf("*** required on your system.\n");
      printf("*** If libprelude-config was wrong, set the environment variable LIBPRELUDE_CONFIG\n");
      printf("*** to point to the correct copy of libprelude-config, and remove the file config.cache\n");
      printf("*** before re-running configure\n");
    }
    else if ( strcmp(prelude_check_version(NULL), LIBPRELUDE_VERSION ) )
    {
      printf("\n*** LIBPRELUDE header file (version %s) does not match\n", LIBPRELUDE_VERSION);
      printf("*** library (version %s)\n", prelude_check_version(NULL) );
    }
    else
    {
      if ( prelude_check_version( "$min_libprelude_version" ) )
      {
        return 0;
      }
     else
      {
        printf("no\n*** An old version of LIBPRELUDE (%s) was found.\n",
                prelude_check_version(NULL) );
        printf("*** You need a version of LIBPRELUDE newer than %s. The latest version of\n",
               "$min_libprelude_version" );
        printf("*** LIBPRELUDE is always available from http://www.prelude-ids.org/download/releases.\n");
        printf("*** \n");
        printf("*** If you have already installed a sufficiently new version, this error\n");
        printf("*** probably means that the wrong copy of the libprelude-config shell script is\n");
        printf("*** being found. The easiest way to fix this is to remove the old version\n");
        printf("*** of LIBPRELUDE, but you can also set the LIBPRELUDE_CONFIG environment to point to the\n");
        printf("*** correct copy of libprelude-config. (In this case, you will have to\n");
        printf("*** modify your LD_LIBRARY_PATH enviroment variable, or edit /etc/ld.so.conf\n");
        printf("*** so that the correct libraries are found at run-time))\n");
      }
    }
  return 1;
}
],, no_libprelude=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
       LDFLAGS="$ac_save_LDFLAGS"
  fi

  if test "x$no_libprelude" = x ; then
     AC_MSG_RESULT(yes)
     ifelse([$2], , :, [$2])
  else
     if test -f conf.libpreludetest ; then
        :
     else
        AC_MSG_RESULT(no)
     fi
     if test "$LIBPRELUDE_CONFIG" = "no" ; then
       echo "*** The libprelude-config script installed by LIBPRELUDE could not be found"
       echo "*** If LIBPRELUDE was installed in PREFIX, make sure PREFIX/bin is in"
       echo "*** your path, or set the LIBPRELUDE_CONFIG environment variable to the"
       echo "*** full path to libprelude-config."
     else
       if test -f conf.libpreludetest ; then
        :
       else
          echo "*** Could not run libprelude test program, checking why..."
          CFLAGS="$CFLAGS $LIBPRELUDE_CFLAGS"
	  LDFLAGS="$LDFLAGS $LIBPRELUDE_LDFLAGS"
          LIBS="$LIBS $LIBPRELUDE_LIBS"
          AC_TRY_LINK([
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <libprelude/prelude.h>
],      [ return !!prelude_check_version(NULL); ],
        [ echo "*** The test program compiled, but did not run. This usually means"
          echo "*** that the run-time linker is not finding LIBPRELUDE or finding the wrong"
          echo "*** version of LIBPRELUDE. If it is not finding LIBPRELUDE, you'll need to set your"
          echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
          echo "*** to the installed location  Also, make sure you have run ldconfig if that"
          echo "*** is required on your system"
          echo "***"
          echo "*** If you have an old version installed, it is best to remove it, although"
          echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH"
          echo "***" ],
        [ echo "*** The test program failed to compile or link. See the file config.log for the"
          echo "*** exact error that occured. This usually means LIBPRELUDE was incorrectly installed"
          echo "*** or that you have moved LIBPRELUDE since it was installed. In the latter case, you"
          echo "*** may want to edit the libprelude-config script: $LIBPRELUDE_CONFIG" ])
          CFLAGS="$ac_save_CFLAGS"
	  LDFLAGS="$ac_save_LDFLAGS"
          LIBS="$ac_save_LIBS"
       fi
     fi
     LIBPRELUDE_CFLAGS=""
     LIBPRELUDE_LDFLAGS=""
     LIBPRELUDE_LIBS=""
     ifelse([$3], , :, [$3])
  fi
  rm -f conf.libpreludetest
  AC_SUBST(LIBPRELUDE_CFLAGS)
  AC_SUBST(LIBPRELUDE_PTHREAD_CFLAGS)
  AC_SUBST(LIBPRELUDE_LDFLAGS)
  AC_SUBST(LIBPRELUDE_LIBS)
  AC_SUBST(LIBPRELUDE_PREFIX)
  AC_SUBST(LIBPRELUDE_CONFIG_PREFIX)
])

dnl *-*wedit:notab*-*  Please keep this as the last line.

