#! /bin/sh


# The following two are the ANSI sequences for start and end embolden
case $TERM in
vt*|ansi*|con*|xterm*|linux*|screen*)
  S=[1m
  E=[m
  ;;
*)
  S=
  E=
  ;;
esac

PW_DIR=`pwd`

if test x$UID != x; then
  TRUST="--with-trusted=0,2,$UID"
else
  TRUST="--with-trusted=0,2"
fi

echo; echo "${S}__ STARTING TEST RUN STEALTH STANDALONE __${E}"; echo;
echo Working directory: $PW_DIR

MAKE=`which gmake`
if test "x$?" = x1 ; then
    MAKE="make -s"
else
    MAKE=`which gmake | sed -e "s%\([a-z:]\) .*%\1%g"` 
    if test "x$MAKE" = x; then
	MAKE="make -s"
    elif test "x$MAKE" = xno; then
	MAKE="make -s"
    else
	if test "x$MAKE" = "xwhich:"; then
		MAKE="make -s"
	else
		MAKE="gmake -s"
		gmake -v >/dev/null 2>&1 || MAKE="make -s"
	fi
    fi
fi

echo MAKE is $MAKE
echo


testrun1 ()
{
	#
	# test standalone compilation
	#
	echo "${S}Building standalone agent${E}"; echo;
	#
	if test -r "Makefile"; then
		$MAKE distclean
	fi
	#
	${TOP_SRCDIR}/configure --quiet $TRUST --enable-debug --enable-xml-log --enable-micro-stealth=137 --enable-nocl=foo --enable-login-watch --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/test/testrc_1   --with-log-file=$PW_DIR/.samhain_log --with-pid-file=$PW_DIR/.samhain_lock --with-data-file=$PW_DIR/.samhain_file 
	#
	if test x$? = x0; then
		echo "configure completed, exit status 0"; echo;
		$MAKE  > /dev/null
		if test x$? = x0; then
		    echo "$MAKE completed, exit status $?"; echo;
		else
		    echo "${S}ERROR:${E} make failed, exit status $?"; echo;
		    exit
		fi

	else
		echo "${S}ERROR:${E} configure failed, exit status $?"; echo;
		exit
	fi

	rm -f ./.samhain_file
	rm -f ./.samhain_log
	rm -f ./.samhain_lock

	echo '-t init' | ./samhain foo

	if test x$? = x0; then
		echo
		echo "${S}init completed${E}"
		echo
		echo '-t check' | ./samhain foo
		if test x$? = x0; then
		    echo "${S}check completed${E}"
		else
		    echo "${S}ERROR:${E} -- check -- failed, exit status $?"
		    echo
		    exit
		fi
	else
		echo "${S}ERROR:${E} -- init -- failed, exit status $?"; echo;
		exit
	fi
	    
}



	testrun1


echo; echo "${S}__ END TEST RUN STANDALONE __${E}"; echo;

exit

