#! /bin/sh


MAXTEST=2; export MAXTEST
LOGFILE="$PW_DIR/.samhain_log"; export LOGFILE
RCFILE="$PW_DIR/testrc_1.dyn";  export RCFILE

testrun1b_internal ()
{
	BUILDOPTS="$1"
	#
	# test standalone compilation
	#
	[ -z "$verbose" ] || { echo; echo "${S}Building standalone agent${E}"; echo; }
	#
	if test -r "Makefile"; then
		$MAKE distclean >/dev/null
	fi
	#
	#
	${TOP_SRCDIR}/configure ${BUILDOPTS} >/dev/null 2>/dev/null
	#
	#
	if test x$? = x0; then
		[ -z "$verbose" ] ||     log_msg_ok "configure..."; 
		$MAKE  > /dev/null
		if test x$? = x0; then
		    [ -z "$verbose" ] || log_msg_ok "make..."; 
		else
		    [ -z "$quiet" ] &&   log_msg_fail "make..."; 
		    return 1
		fi

	else
		[ -z "$quiet" ] &&       log_msg_fail "configure...";
		return 1
	fi

	SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1; exit 0; }' ${SCRIPTDIR}/test.sh`

	tail -n "+$SKIP" ${SCRIPTDIR}/test.sh >/dev/null 2>&1
	if [ $? -eq 0 ]; then
	    tail -n "+$SKIP" ${SCRIPTDIR}/test.sh | gunzip -c - | tar xf - &&  \
		mv "./testrc.gpg.asc" "$RCFILE"
	else
	    tail "+$SKIP" ${SCRIPTDIR}/test.sh | gunzip -c - | tar xf - &&  \
		mv "./testrc.gpg.asc" "$RCFILE"
	fi
	if test x$? = x0; then
	    [ -z "$verbose" ] || log_msg_ok    "extract gpg signed files...";
	else
	    [ -z "$quiet" ]   && log_msg_fail  "extract gpg signed files...";
	    return 1
	fi

	rm -f ./.samhain_file
	rm -f ./.samhain_log
	rm -f ./.samhain_lock

	./samhain -t init -p none -l info

	if test x$? = x0; then
	    [ -z "$verbose" ] || log_msg_ok    "init...";
	else
	    [ -z "$quiet" ]   && log_msg_fail  "init...";
	    return 1
	fi

	mv $PW_DIR/.samhain_file.asc $PW_DIR/.samhain_file
}

do_test_1b () {

    ./samhain -t check -p none -l info
    
    if test x$? = x0; then
	./samhain -j -L $LOGFILE >"${LOGFILE}.tmp" && mv "${LOGFILE}.tmp" "${LOGFILE}"
	if [ $? -ne 0 ]; then
	    [ -z "$quiet" ]   && log_msg_fail  "mv logfile...";
	    return 1
	fi
	[ -z "$verbose" ] || log_msg_ok    "check...";
    else
	[ -z "$quiet" ]   && log_msg_fail  "check...";
	return 1
    fi
    #
    tmp=`egrep "Checking.*/etc(>|\")" $LOGFILE 2>/dev/null | wc -l`
    if [ $tmp -ne 2 ]; then
	[ -z "$verbose" ] || log_msg_fail "/etc";
    fi
    tmp=`egrep "Checking.*(>|\")" $LOGFILE 2>/dev/null | wc -l`
    if [ $tmp -ne 2 ]; then
	[ -z "$verbose" ] || log_msg_fail "checking";
    fi
    #
    return 0
}

do_test_1b_2 () {

    rm -f $PW_DIR/test_log_prelude

    "$PM" --textmod -l $PW_DIR/test_log_prelude --listen 127.0.0.1:5500 >/dev/null 2>&1 &
    PID=$!

    sleep 5

    ./samhain -t check -p none -l info --set-prelude-severity=info --prelude --server-addr 127.0.0.1:5500 >/dev/null
    
    if test x$? = x0; then
	./samhain -j -L $LOGFILE >"${LOGFILE}.tmp" && mv "${LOGFILE}.tmp" "${LOGFILE}"
	if [ $? -ne 0 ]; then
	    [ -z "$quiet" ]   && log_msg_fail  "mv logfile...";
	    kill $PID
	    return 1
	fi
	[ -z "$verbose" ] || log_msg_ok    "check...";
    else
	[ -z "$quiet" ]   && log_msg_fail  "check...";
	kill $PID
	return 1
    fi
    #
    tmp=`egrep 'File original:.*name=etc.*path=/etc' test_log_prelude 2>/dev/null | wc -l`
    if [ $tmp -ne 1 ]; then
	[ -z "$verbose" ] || log_msg_fail "/etc";
    fi
    tmp=`egrep 'Classification text: Checking' test_log_prelude 2>/dev/null | wc -l`
    if [ $tmp -ne 1 ]; then
	[ -z "$verbose" ] || log_msg_fail "checking";
    fi
    tmp=`egrep 'Classification text: Checking' test_log_prelude 2>/dev/null | wc -l`
    if [ $tmp -ne 1 ]; then
	[ -z "$verbose" ] || log_msg_fail "checking";
    fi
    #
    kill $PID
    return 0
}

testrun1b ()
{
    log_start "RUN STANDALONE W/STEALTH W/GPG"
    GPG=`find_path gpg`
    if [ -z "$GPG" ]; then
	log_skip 1 $MAXTEST 'gpg not found in $PATH'
	log_skip 2 $MAXTEST 'gpg not found in $PATH'
    else
	eval "$GPG" --list-keys 0F571F6C >/dev/null 2>/dev/null
	if [ $? -ne 0 ]; then
	    log_skip 1 $MAXTEST 'public PGP key 0x0F571F6C not present'
	    log_skip 2 $MAXTEST 'public PGP key 0x0F571F6C not present'
	else
	    BUILDOPTS="--quiet $TRUST --enable-debug --with-gpg=${GPG} --with-checksum=no --enable-micro-stealth=137 --enable-login-watch --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$RCFILE  --with-log-file=$PW_DIR/.samhain_log --with-pid-file=$PW_DIR/.samhain_lock --with-data-file=$PW_DIR/.samhain_file"
	    testrun1b_internal "${BUILDOPTS}"
	    do_test_1b
	    if [ $? -eq 0 ]; then
		log_ok   1 $MAXTEST 'gpg signed config/database files'
	    else
		log_fail 1 $MAXTEST 'gpg signed config/database files'
	    fi
	    PM=`find_path prelude-manager`
	    if [ -z "$PM" ]; then
		log_skip 2 $MAXTEST 'prelude-manager not found in $PATH'
	    elif [ -z "$doall" ]; then
		log_skip 2 $MAXTEST 'logging to prelude (or use --really-all)'
	    else
		BUILDOPTS="--quiet $TRUST --enable-debug --with-prelude --with-gpg=${GPG} --with-checksum=no --enable-micro-stealth=137 --enable-login-watch --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$RCFILE  --with-log-file=$PW_DIR/.samhain_log --with-pid-file=$PW_DIR/.samhain_lock --with-data-file=$PW_DIR/.samhain_file"
		testrun1b_internal "${BUILDOPTS} CFLAGS=-DSH_NOFAILOVER=1"
		do_test_1b_2
		if [ $? -eq 0 ]; then
		    log_ok   2 $MAXTEST 'logging to prelude'
		else
		    log_fail 2 $MAXTEST 'logging to prelude'
		fi
	    fi
	fi
    fi
    log_end "RUN STANDALONE W/STEALTH W/GPG"
    return 0
}

