/* SAMHAIN file system integrity testing                                   */
/* Copyright (C) 1999 Rainer Wichmann                                      */
/*                                                                         */
/*  This program is free software; you can redistribute it                 */
/*  and/or modify                                                          */
/*  it under the terms of the GNU General Public License as                */
/*  published by                                                           */
/*  the Free Software Foundation; either version 2 of the License, or      */
/*  (at your option) any later version.                                    */
/*                                                                         */
/*  This program is distributed in the hope that it will be useful,        */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of         */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          */
/*  GNU General Public License for more details.                           */
/*                                                                         */
/*  You should have received a copy of the GNU General Public License      */
/*  along with this program; if not, write to the Free Software            */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              */

#ifndef SH_FORWARD_H
#define SH_FORWARD_H

#ifndef SH_STANDALONE
int sh_forward_set_strip (char * str);

#endif

/* generate a random password
 */
int sh_forward_create_password (char * dummy);

/* set time limit
 */
int sh_forward_set_time_limit(char * str);

/* error level for lookup failure
 */
int sh_forward_lookup_level (char * c);

/* create client entry for given password
 */
int sh_forward_make_client (char * str);

#ifdef SH_WITH_SERVER

#ifdef INET_SYSLOG
int set_syslog_active(char * c);
#endif

/* create socket and start listening
 */
void create_server_tcp_socket ();

/* whether to use client address as known to the communication layer
 * and set by accept()
 */
int set_socket_peer (char * c);

/* whether to use client severity
 */
int sh_forward_use_clt_sev (char * c);

/* whether to use client class
 */
int sh_forward_use_clt_class (char * c);

/* server port
 */
int sh_forward_set_port(char * c);

/* server interface
 */
int sh_forward_set_interface(char * c);

/* a wrapper function
 */
void sh_forward_html_write(void);

/* register a client
 */
int sh_forward_register_client (char * str);

/* start server
 */
void sh_receive(void);

/* free() everything
 */
void sh_forward_free_all (void);

#endif

#ifdef SH_WITH_CLIENT
/* talk to server
 */
long  sh_forward (char * errmsg);


/* request file from server. file may be "CONF" or "DATA".
 */
long sh_forward_req_file (char * file);

/* set log server
 */
int sh_forward_setlogserver (char * address);
void reset_count_dev_server(void);

#endif

#endif

