#! /bin/sh

MAXTEST=28; export MAXTEST

testmake ()
{
	fail=0
	if test x$1 = x0; then
		[ -z "$verbose" ]     ||  log_msg_ok  "configure...  $TEST";
		$MAKE  cutest > /dev/null 2>> test_log
		if test x$? = x0; then
		    [ -z "$verbose" ] || log_msg_ok   "make cutest... $TEST";
 		else
		    [ -z "$quiet" ] &&   log_msg_fail "make cutest... $TEST";
		    fail=1
		fi
	else
		[ -z "$quiet" ] &&       log_msg_fail "configure...   $TEST";
	        if [ x"$3" = xskip ]; then
		    [ -z "$quiet" ] && log_skip $2 ${MAXTEST} "$TEST";
		fi
		fail=1
	fi
	if [ $fail -eq 1 ]; then
	    [ -z "$quiet" ] && log_fail $2 ${MAXTEST} "$TEST";
	    return 1
	fi
	[ -z "$quiet" ] &&     log_ok   $2 ${MAXTEST} "$TEST";
	return 0
}

testcompile ()
{
	log_start "COMPILE"

	num=0
	numfail=0

	#
	# test standalone compilation
	#
        TEST="${S}standalone agent w/suidcheck${E}"
	#
	if test -r "Makefile"; then
		$MAKE distclean 
	fi
	#
	${TOP_SRCDIR}/configure --quiet  --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test  --enable-suidcheck > /dev/null 2>> test_log
	#
	let "num = num + 1" >/dev/null
	testmake $? $num || let "numfail = numfail + 1"  >/dev/null

	#
	# test standalone compilation
	#
        TEST="${S}standalone agent w/mounts-check and w/userfiles${E}"
	#
	if test -r "Makefile"; then
		$MAKE distclean 
	fi
	#
	${TOP_SRCDIR}/configure --quiet  --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test  --enable-mounts-check --enable-userfiles  > /dev/null 2>> test_log
	#
	let "num = num + 1" >/dev/null
	testmake $? $num || let "numfail = numfail + 1" >/dev/null


	#
	# test standalone compilation
	#
        TEST="${S}standalone agent w/timeserver and w/message-queue${E}"
	#
	if test -r "Makefile"; then
		$MAKE clean 
	fi
	#
	${TOP_SRCDIR}/configure --quiet  --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test  --enable-message-queue --with-timeserver=127.0.0.1 > /dev/null 2>> test_log
	#
	let "num = num + 1" >/dev/null
	testmake $? $num || let "numfail = numfail + 1" >/dev/null

	#
	# test standalone compilation with --with-nocl=PW
	#
	TEST="${S}standalone agent w/nocl${E}"
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	${TOP_SRCDIR}/configure --quiet  --prefix=$PW_DIR --enable-nocl="owl" --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test > /dev/null 2>> test_log   
	#
	let "num = num + 1" >/dev/null
	testmake $? $num || let "numfail = numfail + 1" >/dev/null

	#
	# test standalone compilation w/ debug
	#
	TEST="${S}standalone agent w/debug${E}"
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	${TOP_SRCDIR}/configure --quiet --enable-debug  --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test  > /dev/null 2>> test_log  
	#
	let "num = num + 1" >/dev/null
	testmake $? $num || let "numfail = numfail + 1" >/dev/null

	#
	# test standalone compilation w/ gpg
	#
	TEST="${S}standalone agent w/gpg${E}"
	#
	GPG=`find_path gpg`
	let "num = num + 1" >/dev/null
	#
	if [ -z "$GPG" ]; then
	    log_skip $num $MAXTEST 'gpg not in PATH'
	else
	    if test -r "Makefile"; then
		$MAKE clean
	    fi
	    #
	    ${TOP_SRCDIR}/configure --quiet --with-gpg=$GPG  --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test > /dev/null 2>> test_log   
	    #
	    testmake $? $num || let "numfail = numfail + 1" >/dev/null
	fi

	#
	# test standalone compilation w/stealth
	#
	TEST="${S}standalone agent w/stealth${E}"
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	${TOP_SRCDIR}/configure --quiet --enable-stealth=128 --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test > /dev/null 2>> test_log   
	#
	let "num = num + 1" >/dev/null
	testmake $? $num || let "numfail = numfail + 1" >/dev/null

	#
	# test standalone compilation w/logwatch
	#
	TEST="${S}standalone agent w/login-watch${E}"
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	${TOP_SRCDIR}/configure --quiet --enable-login-watch  --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test > /dev/null 2>> test_log   
	#
	let "num = num + 1" >/dev/null
	testmake $? $num || let "numfail = numfail + 1" >/dev/null

	#
	# test standalone compilation w/mysql
	#
	TEST="${S}standalone agent w/mysql${E}"
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	${TOP_SRCDIR}/configure --quiet --enable-xml-log --with-database=mysql  --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test > /dev/null 2>> test_log
	#
	let "num = num + 1" >/dev/null
	testmake $? $num "skip" || let "numfail = numfail + 1" >/dev/null

	#
	# test standalone compilation w/postgresql
	#
	TEST="${S}standalone agent w/postgresql${E}"
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	${TOP_SRCDIR}/configure --quiet --enable-xml-log --with-database=postgresql  --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test > /dev/null 2>> test_log
	#
	let "num = num + 1" >/dev/null
	testmake $? $num "skip" || let "numfail = numfail + 1" >/dev/null

	#
	# test standalone compilation
	#
	TEST="${S}standalone agent w/o mail${E}"
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	${TOP_SRCDIR}/configure --quiet --disable-mail --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test  > /dev/null 2>> test_log  
	#
	let "num = num + 1" >/dev/null
	testmake $? $num || let "numfail = numfail + 1" >/dev/null

	#
	# test standalone compilation
	#
	TEST="${S}standalone agent w/o external scripts${E}"
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	${TOP_SRCDIR}/configure --quiet --disable-external-scripts --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test > /dev/null 2>> test_log   
	#
	let "num = num + 1" >/dev/null
	testmake $? $num || let "numfail = numfail + 1" >/dev/null

	# echo; echo "${S}__ TEST CLIENT/SERVER __${E}"; echo;

	#
	# test client/server compilation
	#
	TEST="${S}client/server application w/timeserver${E}"
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	${TOP_SRCDIR}/configure --quiet --enable-network=client  --enable-srp --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test   --with-timeserver=127.0.0.1 > /dev/null 2>> test_log   
	#
	let "num = num + 1" >/dev/null
	testmake $? $num || let "numfail = numfail + 1" >/dev/null
	
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	${TOP_SRCDIR}/configure --quiet --enable-network=server  --enable-srp --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test   --with-timeserver=127.0.0.1 > /dev/null 2>> test_log   
	#
	let "num = num + 1" >/dev/null
	testmake $? $num || let "numfail = numfail + 1" >/dev/null

	#
	# test c/s compilation w/ gpg
	#
	TEST="${S}client/server application w/gpg${E}"
	#
	GPG=`find_path gpg`
	let "num = num + 1" >/dev/null
	#
	if [ -z "$GPG" ]; then
	    log_skip $num $MAXTEST 'gpg not in PATH'
	    let "num = num + 1" >/dev/null
	    log_skip $num $MAXTEST 'gpg not in PATH'
	else
	    if test -r "Makefile"; then
		$MAKE clean
	    fi
	    #
	    ${TOP_SRCDIR}/configure --quiet --enable-network=server  --enable-srp --with-gpg=$GPG  --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test > /dev/null 2>> test_log   
	    #
	    testmake $? $num || let "numfail = numfail + 1" >/dev/null
	    #
	    if test -r "Makefile"; then
		$MAKE clean
	    fi
	    #
	    ${TOP_SRCDIR}/configure --quiet --enable-network=client  --enable-srp --with-gpg=$GPG  --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test > /dev/null 2>> test_log   
	    #
	    let "num = num + 1" >/dev/null
	    testmake $? $num || let "numfail = numfail + 1" >/dev/null
	fi


	#
	# test client/server compilation
	#
	TEST="${S}client/server application w/o srp${E}"
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	${TOP_SRCDIR}/configure --quiet --enable-network=server --disable-srp --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test > /dev/null 2>> test_log   
	#
	let "num = num + 1" >/dev/null
	testmake $? $num || let "numfail = numfail + 1" >/dev/null
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	${TOP_SRCDIR}/configure --quiet --enable-network=client --disable-srp --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test > /dev/null 2>> test_log   
	#
	let "num = num + 1" >/dev/null
	testmake $? $num || let "numfail = numfail + 1" >/dev/null

	#
	# test client/server compilation w/ debug
	#
	TEST="${S}client/server application w/debug${E}"
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	${TOP_SRCDIR}/configure --quiet --enable-network=server --enable-debug --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test > /dev/null 2>> test_log   
	#
	let "num = num + 1" >/dev/null
	testmake $? $num || let "numfail = numfail + 1" >/dev/null
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	${TOP_SRCDIR}/configure --quiet --enable-network=client --enable-debug --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test > /dev/null 2>> test_log   
	#
	let "num = num + 1" >/dev/null
	testmake $? $num || let "numfail = numfail + 1" >/dev/null

	#
	# test client/server compilation w/stealth
	#
	TEST="${S}client/server application w/stealth${E}"
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	${TOP_SRCDIR}/configure --quiet --enable-network=server  --enable-srp --enable-stealth=128 --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test  > /dev/null 2>> test_log  
	#
	let "num = num + 1" >/dev/null
	testmake $? $num || let "numfail = numfail + 1" >/dev/null
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	${TOP_SRCDIR}/configure --quiet --enable-network=client  --enable-srp --enable-stealth=128 --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test  > /dev/null 2>> test_log  
	#
	let "num = num + 1" >/dev/null
	testmake $? $num || let "numfail = numfail + 1" >/dev/null

	#
	# test  client/server compilation w/logwatch
	#
	TEST="${S}client/server application w/login-watch${E}"
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	${TOP_SRCDIR}/configure --quiet --enable-network=server  --enable-srp --enable-login-watch --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test  > /dev/null 2>> test_log  
	#
	let "num = num + 1" >/dev/null
	testmake $? $num || let "numfail = numfail + 1" >/dev/null
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	${TOP_SRCDIR}/configure --quiet --enable-network=client  --enable-srp --enable-login-watch --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test  > /dev/null 2>> test_log  
	#
	let "num = num + 1" >/dev/null
	testmake $? $num || let "numfail = numfail + 1" >/dev/null

	#
	# test client/server compilation
	#
	TEST="${S}client/server application w/o mail${E}"
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	${TOP_SRCDIR}/configure --quiet --enable-network=server  --disable-mail --enable-srp --enable-stealth=128 --enable-debug --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test > /dev/null 2>> test_log   
	#
	let "num = num + 1" >/dev/null
	testmake $? $num || let "numfail = numfail + 1" >/dev/null
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	${TOP_SRCDIR}/configure --quiet --enable-network=client  --disable-mail --enable-srp --enable-stealth=128 --enable-debug --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test > /dev/null 2>> test_log   
	#
	let "num = num + 1" >/dev/null
	testmake $? $num || let "numfail = numfail + 1" >/dev/null

	#
	# test client/server compilation
	#
	TEST="${S}client/server application w/o external scripts${E}"
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	${TOP_SRCDIR}/configure --quiet --enable-network=server  --disable-srp --disable-external-scripts --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test > /dev/null 2>> test_log   
	#
	let "num = num + 1" >/dev/null
	testmake $? $num || let "numfail = numfail + 1" >/dev/null
	#
	if test -r "Makefile"; then
		$MAKE clean
	fi
	#
	${TOP_SRCDIR}/configure --quiet --enable-network=client  --disable-srp --disable-external-scripts --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/samhainrc.test > /dev/null 2>> test_log   
	#
	let "num = num + 1" >/dev/null
	testmake $? $num || let "numfail = numfail + 1" >/dev/null

	log_end "COMPILE"
}
