#ifndef SH_STRING_H
#define SH_STRING_H


/* String definition and utility functions.
 */
typedef struct sh_str_struct
{
  char * str; /* always NULL terminated               */
  size_t len; /* without terminating \0               */
  size_t siz; /* size of allocated buffer             */
} sh_string;

sh_string * sh_string_new(size_t size);
void sh_string_destroy(sh_string ** s);
#define sh_string_str(a) ((a)->str)
#define sh_string_len(a) ((a)->len)

/* concat string to sh_string
 */
sh_string * sh_string_cat_lchar(sh_string * s, char * str, size_t len);

/* set sh_string from string
 */
sh_string * sh_string_set_from_char(sh_string * s, char * str);

/* create new sh_string from array of given length
 */
sh_string * sh_string_new_from_lchar(char * str, size_t len);

#define sh_string_copy(a) ((a) ? sh_string_new_from_lchar(((a)->str), ((a)->len)) : NULL)

/* create new sh_string from three arrays of given length
 */
sh_string * sh_string_new_from_lchar3(char * str1, size_t len1,
                                      char * str2, size_t len2,
                                      char * str3, size_t len3);

/* Truncate to desired length.
 */
sh_string * sh_string_truncate(sh_string * s, size_t len);

/* If requested increase is zero, increase by default amount. 
 */
sh_string * sh_string_grow(sh_string * s, size_t increase);

#endif
