
#ifndef SH_TIGER_H
#define SH_TIGER_H 

#include "config_xor.h"
#include "slib.h"
#include "samhain.h"

typedef enum {
  TIGER_FILE,
  TIGER_FD,
  TIGER_DATA
} TigerType;

extern SL_TICKET tiger_fd;

/* the checksum function
 */
/*@owned@*/ char * sh_tiger_hash (const char * filename, TigerType what, 
				  UINT64 Length);

/* NEW Thu Oct 18 19:59:08 CEST 2001
 */
int sh_tiger_hashtype (const char * c);
char * sh_tiger_generic_hash (char * filename, TigerType what, 
			      UINT64 Length, int timeout);

UINT32 * sh_tiger_hash_uint32 (char * filename, 
			       TigerType what, 
			       UINT64 Length);

/* get the type of hash function used
 * 0 = tiger192, 1 = sha1, 2 = md5
 */
int sh_tiger_get_hashtype ();

/* GnuPG-like format
 */
/*@owned@*/ char * sh_tiger_hash_gpg (const char * filename, TigerType what, 
				      UINT64 Length);
#endif
