
#include "config_xor.h"

#include <string.h>
#include "CuTest.h"

extern char * quote_string   (const char * str);
extern char * unquote_string (const char * str);

void Test_quote_string_ok (CuTest *tc) {

#if defined(SH_WITH_CLIENT) || defined(SH_STANDALONE)
  char * ret = 0;

  char   inp1[] = "foo\nba=r\ntest";
  char   out1[] = "foo=0Aba=3Dr=0Atest";

  char   inp2[] = "\n=foo\nba=r\ntest=\n";
  char   out2[] = "=0A=3Dfoo=0Aba=3Dr=0Atest=3D=0A";

  ret = quote_string(inp1);
  CuAssertPtrNotNull(tc, ret);
  CuAssertStrEquals(tc, out1, ret);

  ret = quote_string(inp2);
  CuAssertPtrNotNull(tc, ret);
  CuAssertStrEquals(tc, out2, ret);
#else
  (void) tc; /* fix compiler warning */
#endif
  return;
}

void Test_unquote_string_ok (CuTest *tc) {
#if defined(SH_WITH_CLIENT) || defined(SH_STANDALONE)
  char * ret = 0;

  char   out1[] = "foo\nba=r\ntes[t";
  char   inp1[] = "foo=0Aba=3Dr=0Ates=5Bt";

  char   out2[] = "\n=foo\nba=r\ntest=\n";
  char   inp2[] = "=0A=3Dfoo=0Aba=3Dr=0Atest=3D=0A";

  char   out3[] = ""; /* encoded '\0' at start */
  char   inp3[] = "=00=3Dfoo=0Aba=3Dr=0Atest=3D=0A";

  ret = unquote_string(inp1);
  CuAssertPtrNotNull(tc, ret);
  CuAssertStrEquals(tc, out1, ret);

  ret = unquote_string(inp2);
  CuAssertPtrNotNull(tc, ret);
  CuAssertStrEquals(tc, out2, ret);

  ret = unquote_string(inp3);
  CuAssertPtrNotNull(tc, ret);
  CuAssertStrEquals(tc, out3, ret);
#else
  (void) tc; /* fix compiler warning */
#endif
  return;
}



