
#include "config_xor.h"

#include <string.h>
#include "CuTest.h"
#include "samhain.h"
#include "sh_utils.h"

void Test_sh_util_strdup_ok (CuTest *tc) {
  char * ret = 0;
  char   inp[] = "foobar";

  ret = sh_util_strdup(inp);
  CuAssertPtrNotNull(tc, ret);
  CuAssert(tc, "expected inp != ret, but inp == ret", (inp != ret)); 
  CuAssertStrEquals(tc, "foobar", ret);
  return;
}

void Test_sh_util_strconcat_ok (CuTest *tc) {
  char * ret = 0;

  ret = sh_util_strconcat("foo", NULL);
  CuAssertPtrNotNull(tc, ret);
  CuAssertStrEquals(tc, "foo", ret);

  ret = sh_util_strconcat("foo", "bar", NULL);
  CuAssertPtrNotNull(tc, ret);
  CuAssertStrEquals(tc, "foobar", ret);

  ret = sh_util_strconcat("/", "foo", "/", "bar", NULL);
  CuAssertPtrNotNull(tc, ret);
  CuAssertStrEquals(tc, "/foo/bar", ret);

  return;
}

void Test_sh_util_dirname_ok (CuTest *tc) {
  char * ret = 0;

  char input0[] = "/foo/bar";
  char res0[] = "/foo";

  char input1[] = "/foo/bar/";
  char res1[] = "/foo";

  char input2[] = "/foo";
  char res2[] = "/";

  char input3[] = "/";
  char res3[] = "/";

  ret = sh_util_dirname(input0);
  CuAssertPtrNotNull(tc, ret);
  CuAssertStrEquals(tc, res0, ret);

  ret = sh_util_dirname(input1);
  CuAssertPtrNotNull(tc, ret);
  CuAssertStrEquals(tc, res1, ret);

  ret = sh_util_dirname(input2);
  CuAssertPtrNotNull(tc, ret);
  CuAssertStrEquals(tc, res2, ret);

  ret = sh_util_dirname(input3);
  CuAssertPtrNotNull(tc, ret);
  CuAssertStrEquals(tc, res3, ret);
  return;
}

void Test_sh_util_basename_ok (CuTest *tc) {
  char * ret = 0;

  char input0[] = "/foo/bar";
  char res0[] = "bar";

  char input1[] = "/foo/";
  char res1[] = "foo";

  char input2[] = "/foo";
  char res2[] = "foo";

  char input3[] = "/";
  char res3[] = "/";

  char input4[] = "/foo/bar/";
  char res4[] = "bar";

  ret = sh_util_basename(input0);
  CuAssertPtrNotNull(tc, ret);
  CuAssertStrEquals(tc, res0, ret);

  ret = sh_util_basename(input1);
  CuAssertPtrNotNull(tc, ret);
  CuAssertStrEquals(tc, res1, ret);

  ret = sh_util_basename(input2);
  CuAssertPtrNotNull(tc, ret);
  CuAssertStrEquals(tc, res2, ret);

  ret = sh_util_basename(input3);
  CuAssertPtrNotNull(tc, ret);
  CuAssertStrEquals(tc, res3, ret);

  ret = sh_util_basename(input4);
  CuAssertPtrNotNull(tc, ret);
  CuAssertStrEquals(tc, res4, ret);

  return;
}

void Test_sh_util_obscure_ok (CuTest *tc) {

  int ret = 0;
#if defined(SH_WITH_CLIENT) || defined(SH_STANDALONE)
  char input[16] = "foobar";

  ret = sh_util_obscure_ok ("0xA1,0xA2,0xA3");
  CuAssertIntEquals(tc, ret, 0);

  ret = sh_util_obscurename (0, input, S_FALSE /* no log message */);
  CuAssertIntEquals(tc, ret, 0);

  input[0] = '\t';
  ret = sh_util_obscurename (0, input, S_FALSE /* no log message */);
  CuAssertIntEquals(tc, ret, -1);

  input[0] = 0xA1;
  ret = sh_util_obscurename (0, input, S_FALSE /* no log message */);
  CuAssertIntEquals(tc, ret, 0);

  input[0] = 0xA2;
  ret = sh_util_obscurename (0, input, S_FALSE /* no log message */);
  CuAssertIntEquals(tc, ret, 0);

  input[0] = 0xA3;
  ret = sh_util_obscurename (0, input, S_FALSE /* no log message */);
  CuAssertIntEquals(tc, ret, 0);

  input[0] = 0xA4;
  ret = sh_util_obscurename (0, input, S_FALSE /* no log message */);
  CuAssertIntEquals(tc, ret, -1);

#else
  CuAssertIntEquals(tc, ret, 0);
#endif
}


