
#include "config_xor.h"

#include <string.h>
#include "CuTest.h"
#include "samhain.h"
#include "sh_unix.h"

void Test_sh_unix_lookup_page (CuTest *tc) {

  long pagesize = sh_unix_pagesize();
  
  unsigned long base;
  int          num_pages;

  CuAssert (tc, "pagesize > 0", (pagesize > 0));

  /* base = sh_unix_lookup_page(in_addr, len, *num_pages); */

  base = sh_unix_lookup_page(0, pagesize, &num_pages);
  CuAssert (tc, "base == 0", (base == 0));
  CuAssertIntEquals (tc, num_pages, 1);

  base = sh_unix_lookup_page(0, pagesize+1, &num_pages);
  CuAssert (tc, "base == 0", (base == 0));
  CuAssertIntEquals (tc, num_pages, 2);

  base = sh_unix_lookup_page((void*)pagesize, pagesize, &num_pages);
  CuAssert (tc, "base == 0", (base == (unsigned int)pagesize));
  CuAssertIntEquals (tc, num_pages, 1);

  base = sh_unix_lookup_page((void*)pagesize, pagesize+1, &num_pages);
  CuAssert (tc, "base == 0", (base == (unsigned int)pagesize));
  CuAssertIntEquals (tc, num_pages, 2);

  base = sh_unix_lookup_page((void*)(pagesize-1), pagesize+1, &num_pages);
  CuAssert (tc, "base == 0", (base == 0));
  CuAssertIntEquals (tc, num_pages, 2);

  base = sh_unix_lookup_page((void*)(pagesize-1), pagesize+2, &num_pages);
  CuAssert (tc, "base == 0", (base == 0));
  CuAssertIntEquals (tc, num_pages, 3);

}

  
